/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.shards;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.store.impl.IdHashShardingStrategy;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.test.shards.Animal;
import org.hibernate.search.test.shards.Furniture;
import org.hibernate.search.test.util.RamIndexManager;

public class ShardsTest
extends SearchTestCase {
    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.directory_provider", "filesystem");
        File sub = this.getBaseIndexDir();
        cfg.setProperty("hibernate.search.default.indexBase", sub.getAbsolutePath());
        cfg.setProperty("hibernate.search.analyzer", StopAnalyzer.class.getName());
        cfg.setProperty("hibernate.search.Animal.sharding_strategy.nbr_of_shards", "2");
        cfg.setProperty("hibernate.search.Animal.0.indexName", "Animal00");
    }

    public void testIdShardingStrategy() {
        IndexManager[] dps = new IndexManager[]{RamIndexManager.makeRamDirectory(), RamIndexManager.makeRamDirectory()};
        IdHashShardingStrategy shardingStrategy = new IdHashShardingStrategy();
        shardingStrategy.initialize(null, dps);
        ShardsTest.assertTrue((dps[1] == shardingStrategy.getIndexManagerForAddition(Animal.class, (Serializable)Integer.valueOf(1), "1", null) ? 1 : 0) != 0);
        ShardsTest.assertTrue((dps[0] == shardingStrategy.getIndexManagerForAddition(Animal.class, (Serializable)Integer.valueOf(2), "2", null) ? 1 : 0) != 0);
        dps[0].destroy();
        dps[1].destroy();
    }

    public void testBehavior() throws Exception {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        Animal a = new Animal();
        a.setId(1);
        a.setName("Elephant");
        s.persist((Object)a);
        a = new Animal();
        a.setId(2);
        a.setName("Bear");
        s.persist((Object)a);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        a = (Animal)s.get(Animal.class, (Serializable)Integer.valueOf(1));
        a.setName("Mouse");
        Furniture fur = new Furniture();
        fur.setColor("dark blue");
        s.persist((Object)fur);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        FullTextSession fts = Search.getFullTextSession((Session)s);
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "id", TestConstants.stopAnalyzer);
        List results = fts.createFullTextQuery(parser.parse("name:mouse OR name:bear"), new Class[0]).list();
        ShardsTest.assertEquals((String)"Either double insert, single update, or query fails with shards", (int)2, (int)results.size());
        results = fts.createFullTextQuery(parser.parse("name:mouse OR name:bear OR color:blue"), new Class[0]).list();
        ShardsTest.assertEquals((String)"Mixing shared and non sharded properties fails", (int)3, (int)results.size());
        results = fts.createFullTextQuery(parser.parse("name:mouse OR name:bear OR color:blue"), new Class[0]).list();
        ShardsTest.assertEquals((String)"Mixing shared and non sharded properties fails with indexreader reuse", (int)3, (int)results.size());
        for (Object o : results) {
            s.delete(o);
        }
        tx.commit();
        s.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInternalSharding() throws Exception {
        int num;
        IndexReader reader;
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        Animal a = new Animal();
        a.setId(1);
        a.setName("Elephant");
        s.persist((Object)a);
        a = new Animal();
        a.setId(2);
        a.setName("Bear");
        s.persist((Object)a);
        tx.commit();
        s.clear();
        FSDirectory animal00Directory = FSDirectory.open((File)new File(this.getBaseIndexDir(), "Animal00"));
        try {
            IndexReader reader2 = IndexReader.open((Directory)animal00Directory, (boolean)true);
            try {
                int num2 = reader2.numDocs();
                ShardsTest.assertEquals((int)1, (int)num2);
            }
            finally {
                reader2.close();
            }
        }
        finally {
            animal00Directory.close();
        }
        FSDirectory animal01Directory = FSDirectory.open((File)new File(this.getBaseIndexDir(), "Animal.1"));
        try {
            reader = IndexReader.open((Directory)animal01Directory);
            try {
                num = reader.numDocs();
                ShardsTest.assertEquals((int)1, (int)num);
            }
            finally {
                reader.close();
            }
        }
        finally {
            animal01Directory.close();
        }
        tx = s.beginTransaction();
        a = (Animal)s.get(Animal.class, (Serializable)Integer.valueOf(1));
        a.setName("Mouse");
        tx.commit();
        s.clear();
        animal01Directory = FSDirectory.open((File)new File(this.getBaseIndexDir(), "Animal.1"));
        try {
            reader = IndexReader.open((Directory)animal01Directory);
            try {
                num = reader.numDocs();
                ShardsTest.assertEquals((int)1, (int)num);
                TermDocs docs = reader.termDocs(new Term("name", "mouse"));
                ShardsTest.assertTrue((boolean)docs.next());
                Document doc = reader.document(docs.doc());
                ShardsTest.assertFalse((boolean)docs.next());
            }
            finally {
                reader.close();
            }
        }
        finally {
            animal01Directory.close();
        }
        tx = s.beginTransaction();
        FullTextSession fts = Search.getFullTextSession((Session)s);
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "id", TestConstants.stopAnalyzer);
        List results = fts.createFullTextQuery(parser.parse("name:mouse OR name:bear"), new Class[0]).list();
        ShardsTest.assertEquals((String)"Either double insert, single update, or query fails with shards", (int)2, (int)results.size());
        for (Object o : results) {
            s.delete(o);
        }
        tx.commit();
        s.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Animal.class, Furniture.class};
    }
}

