/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.similarity;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.hibernate.search.SearchException;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Similarity;
import org.hibernate.search.test.similarity.Can;
import org.hibernate.search.test.similarity.DummySimilarity;
import org.hibernate.search.test.similarity.DummySimilarity2;
import org.hibernate.search.test.similarity.ProperTrashExtension;
import org.hibernate.search.test.similarity.Sink;
import org.hibernate.search.test.similarity.SmallerCan;
import org.hibernate.search.test.similarity.Trash;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class IllegalSimilarityConfigurationTest {
    FullTextSessionBuilder builder = null;

    @After
    public void tearDown() {
        if (this.builder != null) {
            this.builder.close();
        }
    }

    @Test
    public void testValidConfiguration() {
        try {
            this.builder = new FullTextSessionBuilder().addAnnotatedClass(Can.class).addAnnotatedClass(Trash.class).build();
        }
        catch (SearchException e) {
            Assert.fail((String)"A valid configuration could not be started.");
        }
    }

    @Test
    public void testInconsistentAnnotationAndExplicitIndexSimilarityThrowsException() {
        try {
            this.builder = new FullTextSessionBuilder().addAnnotatedClass(Trash.class).setProperty("hibernate.search.garbageIndex.similarity", DummySimilarity2.class.getName()).build();
            Assert.fail((String)"Invalid Similarity declared, should have thrown an exception: entities similarity defined as annotation and config value");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected message: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000188"));
        }
    }

    @Test
    public void testInconsistentAnnotationAndIndexDefaultSimilarityThrowsException() {
        try {
            this.builder = new FullTextSessionBuilder().addAnnotatedClass(Trash.class).setProperty("hibernate.search.default.similarity", DummySimilarity2.class.getName()).build();
            Assert.fail((String)"Invalid Similarity declared, should have thrown an exception: entities similarity defined as annotation and config value");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected message: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000188"));
        }
    }

    @Test
    public void testInconsistentSimilarityInClassSharingAnIndex() {
        try {
            this.builder = new FullTextSessionBuilder().addAnnotatedClass(Trash.class).addAnnotatedClass(Sink.class).build();
            Assert.fail((String)"Invalid Similarity declared, should have thrown an exception: two entities sharing the same index are using a different similarity");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected message: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000189"));
        }
    }

    @Test
    public void testImplicitSimilarityInheritanceIsValid() {
        try {
            this.builder = new FullTextSessionBuilder().addAnnotatedClass(Trash.class).addAnnotatedClass(ProperTrashExtension.class).build();
        }
        catch (SearchException e) {
            Assert.fail((String)"Valid configuration could not be built");
        }
    }

    @Test
    public void testImplicitInconsistentSimilarityInClassHierarchy() {
        try {
            this.builder = new FullTextSessionBuilder().addAnnotatedClass(Can.class).addAnnotatedClass(SmallerCan.class).build();
            Assert.fail((String)"Invalid Similarity declared, should have thrown an exception: child entity is overriding parent's Similarity");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected message: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000189"));
        }
    }

    @Test
    public void testExplicitInconsistentSimilarityInClassHierarchy() {
        try {
            this.builder = new FullTextSessionBuilder().addAnnotatedClass(Parent.class).addAnnotatedClass(Child.class).build();
            Assert.fail((String)"Invalid Similarity declared, should have thrown an exception: same similarity must be used across class hierarchy");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected message: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000187"));
        }
    }

    @Entity
    @Indexed
    @Similarity(impl=DummySimilarity.class)
    public class Child
    extends Parent {
    }

    @Entity
    @Similarity(impl=DummySimilarity2.class)
    public class Parent {
        @Id
        @GeneratedValue
        private Integer id;
    }
}

