/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.batchindexing;

import java.util.Properties;
import java.util.concurrent.Future;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hibernate.CacheMode;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.MassIndexer;
import org.hibernate.search.Search;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.spi.MassIndexerFactory;
import org.hibernate.search.test.SearchTestCaseJUnit4;
import org.hibernate.search.test.batchindexing.Clock;
import org.junit.Assert;
import org.junit.Test;

public class CustomMassIndexerFactoryTest
extends SearchTestCaseJUnit4 {
    @Test
    public void testCreationOfTheSelectedMassIndexer() throws Exception {
        Session session = this.openSession();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        MassIndexer indexer = fullTextSession.createIndexer(new Class[]{Clock.class});
        Assert.assertThat((Object)indexer, (Matcher)CoreMatchers.is(NoopMassIndexer.class));
    }

    @Test
    public void testFactoryCanReadConfiguration() throws Exception {
        Session session = this.openSession();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        NoopMassIndexer indexer = (NoopMassIndexer)fullTextSession.createIndexer(new Class[]{Clock.class});
        Assert.assertTrue((String)"The factory cannot read the configuration properties", (boolean)indexer.isConfigurationReadable());
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.massindexer.factoryclass", NoopMassIndexerFactory.class.getName());
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Clock.class};
    }

    private static class NoopMassIndexer
    implements MassIndexer {
        private final boolean configurationReadable;

        public NoopMassIndexer(boolean configurationAccessible) {
            this.configurationReadable = configurationAccessible;
        }

        public boolean isConfigurationReadable() {
            return this.configurationReadable;
        }

        public MassIndexer typesToIndexInParallel(int threadsToIndexObjects) {
            return null;
        }

        public MassIndexer threadsToLoadObjects(int numberOfThreads) {
            return null;
        }

        public MassIndexer batchSizeToLoadObjects(int batchSize) {
            return null;
        }

        public MassIndexer threadsForSubsequentFetching(int numberOfThreads) {
            return null;
        }

        @Deprecated
        public MassIndexer threadsForIndexWriter(int numberOfThreads) {
            return null;
        }

        public MassIndexer progressMonitor(MassIndexerProgressMonitor monitor) {
            return null;
        }

        public MassIndexer cacheMode(CacheMode cacheMode) {
            return null;
        }

        public MassIndexer optimizeOnFinish(boolean optimize) {
            return null;
        }

        public MassIndexer optimizeAfterPurge(boolean optimize) {
            return null;
        }

        public MassIndexer purgeAllOnStart(boolean purgeAll) {
            return null;
        }

        public MassIndexer limitIndexedObjectsTo(long maximum) {
            return null;
        }

        public Future<?> start() {
            return null;
        }

        public void startAndWait() throws InterruptedException {
        }

        public MassIndexer idFetchSize(int idFetchSize) {
            return null;
        }
    }

    public static class NoopMassIndexerFactory
    implements MassIndexerFactory {
        private boolean configurationReadable = false;

        public void initialize(Properties properties) {
            this.configurationReadable = properties.get("hibernate.search.massindexer.factoryclass") == NoopMassIndexerFactory.class.getName();
        }

        public MassIndexer createMassIndexer(SearchFactoryImplementor searchFactory, SessionFactoryImplementor sessionFactory, Class<?> ... entities) {
            return new NoopMassIndexer(this.configurationReadable);
        }
    }
}

