/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import java.util.Date;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.bridge.MapBridgeTestEntity;

public class MapBridgeTest
extends SearchTestCase {
    private FullTextSession fullTextSession;
    private MapBridgeTestEntity withoutNull;
    private MapBridgeTestEntity withNullEntry;
    private MapBridgeTestEntity withNullEmbedded;
    private Date indexedDate;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Session session = this.openSession();
        this.fullTextSession = Search.getFullTextSession((Session)session);
        this.prepareData();
    }

    @Override
    public void tearDown() throws Exception {
        this.cleanData();
        MapBridgeTest.assertTrue((boolean)this.indexIsEmpty());
        super.tearDown();
    }

    private void prepareData() {
        Transaction tx = this.fullTextSession.beginTransaction();
        this.withoutNull = this.persistEntity((Session)this.fullTextSession, "Davide D'Alto");
        this.withoutNull.addNullIndexed(1, MapBridgeTestEntity.Language.ITALIAN);
        this.withoutNull.addNullIndexed(2, MapBridgeTestEntity.Language.ENGLISH);
        this.withoutNull.addNumericNullIndexed(1, 1);
        this.withoutNull.addNumericNullIndexed(2, 2);
        this.withoutNull.addNullNotIndexed(1, "DaltoValue");
        this.withoutNull.addNullNotIndexed(2, "DavideValue");
        this.withoutNull.addNumericNullNotIndexed(1, 3L);
        this.withoutNull.addNumericNullNotIndexed(2, 4L);
        this.indexedDate = new Date();
        this.withoutNull.addDate(1, this.indexedDate);
        this.withNullEntry = this.persistEntity((Session)this.fullTextSession, "Worf");
        this.withNullEntry.addNullIndexed(1, MapBridgeTestEntity.Language.KLINGON);
        this.withNullEntry.addNullIndexed(2, MapBridgeTestEntity.Language.ENGLISH);
        this.withNullEntry.addNullIndexed(3, null);
        this.withNullEntry.addNumericNullIndexed(1, 11);
        this.withNullEntry.addNumericNullIndexed(2, null);
        this.withNullEntry.addNullNotIndexed(1, "WorfValue");
        this.withNullEntry.addNullNotIndexed(2, null);
        this.withNullEntry.addNumericNullNotIndexed(1, 33L);
        this.withNullEntry.addNumericNullNotIndexed(2, null);
        this.withNullEntry.addDate(1, null);
        this.withNullEmbedded = this.persistEntity((Session)this.fullTextSession, "Mime");
        this.withNullEmbedded.setDates(null);
        this.withNullEmbedded.setNumericNullIndexed(null);
        this.withNullEmbedded.setNumericNullNotIndexed(null);
        this.withNullEmbedded.setNullIndexed(null);
        this.withNullEmbedded.setNullNotIndexed(null);
        this.withNullEmbedded.setDates(null);
        tx.commit();
    }

    public void testSearchNullEntry() throws Exception {
        List<MapBridgeTestEntity> results = this.findResults("nullIndexed", "NULL_MARKER");
        MapBridgeTest.assertNotNull((String)"No result found for an indexed collection", results);
        MapBridgeTest.assertEquals((String)"Unexpected number of results in a collection", (int)1, (int)results.size());
        MapBridgeTest.assertEquals((String)"Wrong result returned looking for a null in a collection", (String)this.withNullEntry.getName(), (String)results.get(0).getName());
    }

    public void testSearchNullEmbedded() throws Exception {
        List<MapBridgeTestEntity> results = this.findEmbeddedNullResults("nullIndexed", "EMBEDDED_NULL");
        MapBridgeTest.assertNotNull((String)"No result found for an indexed collection", results);
        MapBridgeTest.assertEquals((String)"Unexpected number of results in a collection", (int)1, (int)results.size());
        MapBridgeTest.assertEquals((String)"Wrong result returned looking for a null in a collection", (String)this.withNullEmbedded.getName(), (String)results.get(0).getName());
    }

    public void testSearchNullNumericEmbedded() throws Exception {
        List<MapBridgeTestEntity> results = this.findEmbeddedNullResults("embeddedNum", "EMBEDDED_NUMERIC_NULL");
        MapBridgeTest.assertNotNull((String)"No result found for an indexed collection", results);
        MapBridgeTest.assertEquals((String)"Unexpected number of results in a collection", (int)1, (int)results.size());
        MapBridgeTest.assertEquals((String)"Wrong result returned looking for a null in a collection of numeric", (String)this.withNullEmbedded.getName(), (String)results.get(0).getName());
    }

    public void testSearchNullNumericEntry() throws Exception {
        List<MapBridgeTestEntity> results = this.findResults("numericNullIndexed", "NULL_NUMERIC_MARKER");
        MapBridgeTest.assertNotNull((String)"No result found for an indexed collection", results);
        MapBridgeTest.assertEquals((String)"Unexpected number of results in a collection", (int)1, (int)results.size());
        MapBridgeTest.assertEquals((String)"Wrong result returned looking for a null in a collection of numeric", (String)this.withNullEntry.getName(), (String)results.get(0).getName());
    }

    public void testSearchNotNullEntry() throws Exception {
        List<MapBridgeTestEntity> results = this.findResults("nullIndexed", (Object)MapBridgeTestEntity.Language.KLINGON);
        MapBridgeTest.assertNotNull((String)"No result found for an indexed collection", results);
        MapBridgeTest.assertEquals((String)"Wrong number of results returned for an indexed collection", (int)1, (int)results.size());
        MapBridgeTest.assertEquals((String)"Wrong result returned from an indexed collection", (String)this.withNullEntry.getName(), (String)results.get(0).getName());
        results = this.findResults("nullIndexed", (Object)MapBridgeTestEntity.Language.ITALIAN);
        MapBridgeTest.assertNotNull((String)"No result found for an indexed collection", results);
        MapBridgeTest.assertEquals((String)"Wrong number of results returned for an indexed collection", (int)1, (int)results.size());
        MapBridgeTest.assertEquals((String)"Wrong result returned from an indexed collection", (String)this.withoutNull.getName(), (String)results.get(0).getName());
        results = this.findResults("nullIndexed", (Object)MapBridgeTestEntity.Language.ENGLISH);
        MapBridgeTest.assertNotNull((String)"No result found for an indexed collection", results);
        MapBridgeTest.assertEquals((String)"Wrong number of results returned for an indexed collection", (int)2, (int)results.size());
    }

    public void testSearchEntryWhenNullEntryNotIndexed() throws Exception {
        List<MapBridgeTestEntity> results = this.findResults("nullNotIndexed", "DaltoValue");
        MapBridgeTest.assertNotNull((String)"No result found for an indexed array", results);
        MapBridgeTest.assertEquals((String)"Wrong number of results returned for an indexed array", (int)1, (int)results.size());
        MapBridgeTest.assertEquals((String)"Wrong result returned from an indexed array", (String)this.withoutNull.getName(), (String)results.get(0).getName());
        results = this.findResults("nullNotIndexed", "WorfValue");
        MapBridgeTest.assertNotNull((String)"No result found for an indexed array", results);
        MapBridgeTest.assertEquals((String)"Wrong number of results returned for an indexed array", (int)1, (int)results.size());
        MapBridgeTest.assertEquals((String)"Wrong result returned from an indexed array", (String)this.withNullEntry.getName(), (String)results.get(0).getName());
    }

    public void testSearchNotNullNumeric() throws Exception {
        List<MapBridgeTestEntity> results = this.findNumericResults("numericNullIndexed", 1);
        MapBridgeTest.assertNotNull((String)"No result found for an indexed collection", results);
        MapBridgeTest.assertEquals((String)"Wrong number of results returned for an indexed collection", (int)1, (int)results.size());
        MapBridgeTest.assertEquals((String)"Wrong result returned from an indexed collection", (String)this.withoutNull.getName(), (String)results.get(0).getName());
        results = this.findNumericResults("numericNullIndexed", 11);
        MapBridgeTest.assertNotNull((String)"No result found for an indexed collection", results);
        MapBridgeTest.assertEquals((String)"Wrong number of results returned for an indexed collection", (int)1, (int)results.size());
        MapBridgeTest.assertEquals((String)"Wrong result returned from an indexed collection", (String)this.withNullEntry.getName(), (String)results.get(0).getName());
    }

    public void testSearchNotNullNumericEntryWhenNullEntryNotIndexed() throws Exception {
        List<MapBridgeTestEntity> results = this.findNumericResults("numericNullNotIndexed", 3L);
        MapBridgeTest.assertNotNull((String)"No result found for an indexed array", results);
        MapBridgeTest.assertEquals((String)"Wrong number of results returned for an indexed array", (int)1, (int)results.size());
        MapBridgeTest.assertEquals((String)"Wrong result returned from an indexed array", (String)this.withoutNull.getName(), (String)results.get(0).getName());
        results = this.findNumericResults("numericNullNotIndexed", 33L);
        MapBridgeTest.assertNotNull((String)"No result found for an indexed array", results);
        MapBridgeTest.assertEquals((String)"Wrong number of results returned for an indexed array", (int)1, (int)results.size());
        MapBridgeTest.assertEquals((String)"Wrong result returned from an indexed array", (String)this.withNullEntry.getName(), (String)results.get(0).getName());
    }

    public void testDateIndexing() throws Exception {
        List<MapBridgeTestEntity> results = this.findResults("dates", this.indexedDate);
        MapBridgeTest.assertNotNull((String)"No result found for an indexed collection", results);
        MapBridgeTest.assertEquals((String)"Wrong number of results returned for an indexed collection", (int)1, (int)results.size());
        MapBridgeTest.assertEquals((String)"Wrong result returned from a collection of Date", (String)this.withoutNull.getName(), (String)results.get(0).getName());
    }

    private List<MapBridgeTestEntity> findEmbeddedNullResults(String fieldName, Object value) {
        QueryBuilder queryBuilder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(MapBridgeTestEntity.class).get();
        Query query = ((TermMatchingContext)queryBuilder.keyword().onField(fieldName).ignoreAnalyzer()).matching(value).createQuery();
        return this.fullTextSession.createFullTextQuery(query, new Class[]{MapBridgeTestEntity.class}).list();
    }

    private List<MapBridgeTestEntity> findResults(String fieldName, Object value) {
        QueryBuilder queryBuilder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(MapBridgeTestEntity.class).get();
        Query query = queryBuilder.keyword().onField(fieldName).matching(value).createQuery();
        return this.fullTextSession.createFullTextQuery(query, new Class[]{MapBridgeTestEntity.class}).list();
    }

    private List<MapBridgeTestEntity> findNumericResults(String fieldName, Object number) {
        Query query = NumericFieldUtils.createNumericRangeQuery((String)fieldName, (Object)number, (Object)number, (boolean)true, (boolean)true);
        return this.fullTextSession.createFullTextQuery(query, new Class[]{MapBridgeTestEntity.class}).list();
    }

    private MapBridgeTestEntity persistEntity(Session s, String name) {
        MapBridgeTestEntity boy = new MapBridgeTestEntity();
        boy.setName(name);
        s.persist((Object)boy);
        return boy;
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{MapBridgeTestEntity.class};
    }

    private void cleanData() {
        Transaction tx = this.fullTextSession.beginTransaction();
        List locations = this.fullTextSession.createCriteria(MapBridgeTestEntity.class).list();
        for (MapBridgeTestEntity location : locations) {
            this.fullTextSession.delete((Object)location);
        }
        tx.commit();
        this.fullTextSession.close();
    }

    private boolean indexIsEmpty() {
        int numDocsForeigner = this.countSizeForType(MapBridgeTestEntity.class);
        return numDocsForeigner == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countSizeForType(Class<?> type) {
        SearchFactory searchFactory = this.fullTextSession.getSearchFactory();
        int numDocs = -1;
        IndexReader locationIndexReader = searchFactory.getIndexReaderAccessor().open(new Class[]{type});
        try {
            numDocs = locationIndexReader.numDocs();
        }
        finally {
            searchFactory.getIndexReaderAccessor().close(locationIndexReader);
        }
        return numDocs;
    }
}

