/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.dsl;

import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.Spatial;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.spatial.Coordinates;

@Entity
@Indexed
public class POI {
    @Id
    Integer id;
    @Field(store=Store.YES)
    String name;
    @Field(store=Store.YES, index=Index.YES)
    String type;
    @Field(store=Store.YES, index=Index.YES)
    @NumericField
    double latitude;
    @Field(store=Store.YES, index=Index.YES)
    @NumericField
    double longitude;

    @Spatial
    @Embedded
    public Coordinates getLocation() {
        return new Coordinates(){

            public Double getLatitude() {
                return POI.this.latitude;
            }

            public Double getLongitude() {
                return POI.this.longitude;
            }
        };
    }

    public POI(Integer id, String name, double latitude, double longitude, String type) {
        this.id = id;
        this.name = name;
        this.latitude = latitude;
        this.longitude = longitude;
        this.type = type;
    }

    public POI() {
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String getType() {
        return this.type;
    }
}

