/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.serialization;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Protocol;
import org.hibernate.search.SearchException;

public class AvroUtils {
    private static Map<String, String> schemas = new HashMap<String, String>();

    private AvroUtils() {
    }

    public static void parseSchema(String filename, String name) {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
        String messageSchemaAsString = AvroUtils.readInputStream(in, filename);
        AvroUtils.addSchema(name, messageSchemaAsString);
    }

    public static String readInputStream(InputStream inputStream, String filename) {
        try {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1000];
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            int r = reader.read(buffer);
            while (r != -1) {
                ((Writer)writer).write(buffer, 0, r);
                r = reader.read(buffer);
            }
            return ((Object)writer).toString();
        }
        catch (IOException e) {
            throw new SearchException("Unable to read " + filename, (Throwable)e);
        }
    }

    public static void addSchema(String name, String schema) {
        schemas.put("`" + name + "`", schema);
    }

    public static Protocol parseProtocol(String filename, String name) {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
        String protocolSkeleton = AvroUtils.readInputStream(in, filename);
        String protocolString = AvroUtils.inlineSchemas(protocolSkeleton);
        return Protocol.parse((String)protocolString);
    }

    public static String inlineSchemas(String protocolSkeleton) {
        String result = protocolSkeleton;
        for (Map.Entry<String, String> entry : schemas.entrySet()) {
            result = AvroUtils.replace(result, entry.getKey(), entry.getValue().toString());
        }
        return result;
    }

    static String replace(String str, String pattern, String replace) {
        int s = 0;
        int e = 0;
        StringBuilder result = new StringBuilder();
        while ((e = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e));
            result.append(replace);
            s = e + pattern.length();
        }
        result.append(str.substring(s));
        return result.toString();
    }
}

