/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.shards;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.fest.assertions.Assertions;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.engine.ServiceManager;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.hcore.impl.HibernateSessionFactoryServiceProvider;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.store.ShardIdentifierProviderTemplate;
import org.hibernate.search.test.SearchTestCaseJUnit4;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.test.shards.Animal;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DynamicShardingTest
extends SearchTestCaseJUnit4 {
    private Animal elephant;
    private Animal spider;
    private Animal bear;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.elephant = new Animal();
        this.elephant.setId(1);
        this.elephant.setName("Elephant");
        this.elephant.setType("Mammal");
        this.spider = new Animal();
        this.spider.setId(2);
        this.spider.setName("Spider");
        this.spider.setType("Insect");
        this.bear = new Animal();
        this.bear.setId(3);
        this.bear.setName("Bear");
        this.bear.setType("Mammal");
    }

    @Test
    public void testDynamicCreationOfShards() throws Exception {
        EntityIndexBinding entityIndexBinding = (EntityIndexBinding)this.getSearchFactoryImpl().getIndexBindings().get(Animal.class);
        Assertions.assertThat((Object[])entityIndexBinding.getIndexManagers()).hasSize(0);
        this.insertAnimals(this.elephant);
        Assertions.assertThat((Object[])entityIndexBinding.getIndexManagers()).hasSize(1);
        this.insertAnimals(this.spider);
        Assertions.assertThat((Object[])entityIndexBinding.getIndexManagers()).hasSize(2);
        this.insertAnimals(this.bear);
        Assertions.assertThat((Object[])entityIndexBinding.getIndexManagers()).hasSize(2);
        this.assertNumberOfEntitiesInIndex("Animal.Mammal", 2);
        this.assertNumberOfEntitiesInIndex("Animal.Insect", 1);
    }

    @Test
    public void testDynamicShardsAreTargetingInQuery() throws Exception {
        this.insertAnimals(this.elephant, this.spider, this.bear);
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        FullTextSession fts = Search.getFullTextSession((Session)session);
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "id", TestConstants.stopAnalyzer);
        List results = fts.createFullTextQuery(parser.parse("name:bear OR name:elephant OR name:spider"), new Class[0]).list();
        Assert.assertEquals((String)"Either double insert, single update, or query fails with shards", (long)3L, (long)results.size());
        tx.commit();
        session.close();
    }

    @Test
    public void testInitialiseDynamicShardsOnStartup() throws Exception {
        EntityIndexBinding entityIndexBinding = (EntityIndexBinding)this.getSearchFactoryImpl().getIndexBindings().get(Animal.class);
        Assertions.assertThat((Object[])entityIndexBinding.getIndexManagers()).hasSize(0);
        this.insertAnimals(this.elephant, this.spider, this.bear);
        Assertions.assertThat((Object[])entityIndexBinding.getIndexManagers()).hasSize(2);
        SearchFactoryImplementor newSearchFactory = this.getIndependentNewSearchFactory();
        entityIndexBinding = (EntityIndexBinding)newSearchFactory.getIndexBindings().get(Animal.class);
        Assertions.assertThat((Object[])entityIndexBinding.getIndexManagers()).hasSize(2);
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.Animal.sharding_strategy", AnimalShardIdentifierProvider.class.getName());
        cfg.setProperty("hibernate.search.default.directory_provider", "filesystem");
        File sub = this.getBaseIndexDir();
        cfg.setProperty("hibernate.search.default.indexBase", sub.getAbsolutePath());
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Animal.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertNumberOfEntitiesInIndex(String indexName, int expectedCount) throws IOException {
        FSDirectory fsDirectory = FSDirectory.open((File)new File(this.getBaseIndexDir(), indexName));
        try {
            IndexReader reader = IndexReader.open((Directory)fsDirectory);
            try {
                int actualCount = reader.numDocs();
                Assert.assertEquals((String)"Unexpected document count", (long)expectedCount, (long)actualCount);
            }
            finally {
                reader.close();
            }
        }
        finally {
            fsDirectory.close();
        }
    }

    private void insertAnimals(Animal ... animals) {
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        for (Animal animal : animals) {
            session.persist((Object)animal);
        }
        tx.commit();
        session.clear();
    }

    private SearchFactoryImplementor getIndependentNewSearchFactory() {
        Configuration config = new Configuration();
        config.setProperty("hibernate.search.Animal.sharding_strategy", AnimalShardIdentifierProvider.class.getName());
        config.setProperty("hibernate.search.default.directory_provider", "filesystem");
        File sub = this.getBaseIndexDir();
        config.setProperty("hibernate.search.default.indexBase", sub.getAbsolutePath());
        config.addAnnotatedClass(Animal.class);
        SessionFactory newSessionFactory = config.buildSessionFactory();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)newSessionFactory.openSession());
        return (SearchFactoryImplementor)fullTextSession.getSearchFactory();
    }

    public static class AnimalShardIdentifierProvider
    extends ShardIdentifierProviderTemplate {
        public String getShardIdentifier(Class<?> entityType, Serializable id, String idAsString, Document document) {
            if (entityType.equals(Animal.class)) {
                String type = document.getFieldable("type").stringValue();
                this.addShard(type);
                return type;
            }
            throw new RuntimeException("Animal expected but found " + entityType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Set<String> loadInitialShardNames(Properties properties, BuildContext buildContext) {
            ServiceManager serviceManager = buildContext.getServiceManager();
            SessionFactory sessionFactory = (SessionFactory)serviceManager.requestService(HibernateSessionFactoryServiceProvider.class, buildContext);
            Session session = sessionFactory.openSession();
            try {
                Criteria initialShardsCriteria = session.createCriteria(Animal.class);
                initialShardsCriteria.setProjection(Projections.distinct((Projection)Property.forName((String)"type")));
                List initialTypes = initialShardsCriteria.list();
                HashSet<String> hashSet = new HashSet<String>(initialTypes);
                return hashSet;
            }
            finally {
                session.close();
            }
        }
    }
}

