/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.nested;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.test.embedded.nested.Place;

@Entity
@Indexed
public class Person {
    @Id
    @GeneratedValue
    private long id;
    String name;
    @IndexedEmbedded
    @ManyToMany(cascade={CascadeType.ALL})
    private List<Place> placesVisited = new ArrayList<Place>(0);

    public Person() {
    }

    public Person(String name) {
        this();
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<Place> getPlacesVisited() {
        return this.placesVisited;
    }

    public void addPlaceVisited(Place place) {
        this.placesVisited.add(place);
    }

    public long getId() {
        return this.id;
    }
}

