/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine.worker;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCaseJUnit4;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.test.engine.worker.Employee;
import org.hibernate.search.test.engine.worker.Employer;
import org.junit.Assert;
import org.junit.Test;

public class WorkerTestCase
extends SearchTestCaseJUnit4 {
    @Test
    public void testConcurrency() throws Exception {
        AtomicBoolean allFine = new AtomicBoolean(true);
        int nThreads = 15;
        ExecutorService es = Executors.newFixedThreadPool(nThreads);
        Work work = new Work(this.getSessionFactory(), allFine, this.isWorkerSync());
        ReverseWork reverseWork = new ReverseWork(this.getSessionFactory(), allFine);
        long start = System.nanoTime();
        int iteration = 100;
        for (int i = 0; i < iteration; ++i) {
            es.execute(work);
            es.execute(reverseWork);
        }
        es.shutdown();
        es.awaitTermination(100L, TimeUnit.MINUTES);
        this.getSessionFactory().close();
        Assert.assertTrue((String)"Something was wrong in the concurrent threads, please check logs for stacktraces", (boolean)allFine.get());
        System.out.println(iteration + " iterations (8 tx per iteration) in " + nThreads + " threads: " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.directory_provider", "ram");
        cfg.setProperty("hibernate.search.analyzer", StopAnalyzer.class.getName());
        cfg.setProperty("hibernate.show_sql", "false");
        cfg.setProperty("hibernate.format_sql", "false");
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Employee.class, Employer.class};
    }

    protected boolean isWorkerSync() {
        return true;
    }

    protected static final class ReverseWork
    implements Runnable {
        private final SessionFactory sf;
        private final AtomicBoolean allFine;

        public ReverseWork(SessionFactory sf, AtomicBoolean allFine) {
            this.sf = sf;
            this.allFine = allFine;
        }

        @Override
        public void run() {
            try {
                Session s = this.sf.openSession();
                Transaction tx = s.beginTransaction();
                Employer er = new Employer();
                er.setName("RH");
                s.persist((Object)er);
                Employee ee = new Employee();
                ee.setName("Emmanuel");
                s.persist((Object)ee);
                tx.commit();
                s.close();
                s = this.sf.openSession();
                tx = s.beginTransaction();
                er = (Employer)s.get(Employer.class, (Serializable)Long.valueOf(er.getId()));
                er.setName("RH2");
                ee = (Employee)s.get(Employee.class, (Serializable)Long.valueOf(ee.getId()));
                ee.setName("Emmanuel2");
                tx.commit();
                s.close();
                s = this.sf.openSession();
                tx = s.beginTransaction();
                er = (Employer)s.get(Employer.class, (Serializable)Long.valueOf(er.getId()));
                s.delete((Object)er);
                ee = (Employee)s.get(Employee.class, (Serializable)Long.valueOf(ee.getId()));
                s.delete((Object)ee);
                tx.commit();
                s.close();
            }
            catch (Throwable t) {
                this.allFine.set(false);
                t.printStackTrace();
            }
        }
    }

    protected static final class Work
    implements Runnable {
        private final SessionFactory sf;
        private final AtomicBoolean allFine;
        private final boolean isWorkerSync;

        public Work(SessionFactory sf, AtomicBoolean allFine, boolean isWorkerSync) {
            this.sf = sf;
            this.allFine = allFine;
            this.isWorkerSync = isWorkerSync;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Session s = null;
            Transaction tx = null;
            try {
                boolean results;
                Query query;
                s = this.sf.openSession();
                tx = s.beginTransaction();
                Employer er = new Employer();
                er.setName("RH");
                s.persist((Object)er);
                Employee ee = new Employee();
                ee.setName("Emmanuel");
                s.persist((Object)ee);
                tx.commit();
                s.close();
                s = this.sf.openSession();
                tx = s.beginTransaction();
                ee = (Employee)s.get(Employee.class, (Serializable)Long.valueOf(ee.getId()));
                ee.setName("Emmanuel2");
                tx.commit();
                s.close();
                s = this.sf.openSession();
                tx = s.beginTransaction();
                er = (Employer)s.get(Employer.class, (Serializable)Long.valueOf(er.getId()));
                er.setName("RH2");
                tx.commit();
                s.close();
                s = this.sf.openSession();
                tx = s.beginTransaction();
                QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "id", TestConstants.stopAnalyzer);
                try {
                    query = parser.parse("name:emmanuel2");
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
                boolean bl = results = Search.getFullTextSession((Session)s).createFullTextQuery(query, new Class[0]).list().size() > 0;
                if (this.isWorkerSync) {
                    Assert.assertTrue((boolean)results);
                }
                tx.commit();
                s.close();
                s = this.sf.openSession();
                tx = s.beginTransaction();
                er = (Employer)s.get(Employer.class, (Serializable)Long.valueOf(er.getId()));
                s.delete((Object)er);
                tx.commit();
                s.close();
                s = this.sf.openSession();
                tx = s.beginTransaction();
                ee = (Employee)s.get(Employee.class, (Serializable)Long.valueOf(ee.getId()));
                s.delete((Object)ee);
                tx.commit();
                s.close();
            }
            catch (Throwable t) {
                this.allFine.set(false);
                t.printStackTrace();
            }
            finally {
                try {
                    if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                    if (s != null && s.isOpen()) {
                        s.close();
                    }
                }
                catch (Throwable t) {
                    this.allFine.set(false);
                    t.printStackTrace();
                }
            }
        }
    }
}

