/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.analyzer;

import java.util.HashSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.boot.registry.classloading.internal.ClassLoaderServiceImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.cfg.impl.SearchConfigurationFromHibernateCore;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.SearchFactory;
import org.hibernate.search.engine.metadata.impl.AnnotationMetadataProvider;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.impl.ConfigContext;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.analyzer.Article;
import org.hibernate.search.test.analyzer.BlogEntry;
import org.hibernate.search.test.analyzer.MyComponent;
import org.hibernate.search.test.analyzer.MyEntity;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.testsupport.setup.BuildContextForTest;
import org.hibernate.search.util.AnalyzerUtils;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.junit.Assert;
import org.junit.Test;

public class AnalyzerTest
extends SearchTestBase {
    public static final Log log = LoggerFactory.make();

    @Test
    public void testAnalyzerDiscriminator() throws Exception {
        Article germanArticle = new Article();
        germanArticle.setLanguage("de");
        germanArticle.setText("aufeinanderschl\u00fcgen");
        HashSet<Article> references = new HashSet<Article>();
        references.add(germanArticle);
        Article englishArticle = new Article();
        englishArticle.setLanguage("en");
        englishArticle.setText("acknowledgment");
        englishArticle.setReferences(references);
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        s.persist((Object)englishArticle);
        tx.commit();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "references.text", TestConstants.standardAnalyzer);
        Query luceneQuery = parser.parse("aufeinanderschlug");
        FullTextQuery query = s.createFullTextQuery(luceneQuery, new Class[0]);
        Assert.assertEquals((long)1L, (long)query.getResultSize());
        parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "text", TestConstants.standardAnalyzer);
        luceneQuery = parser.parse("acknowledg");
        query = s.createFullTextQuery(luceneQuery, new Class[0]);
        Assert.assertEquals((long)1L, (long)query.getResultSize());
        tx.commit();
        s.close();
    }

    @Test
    public void testMultipleAnalyzerDiscriminatorDefinitions() {
        SearchConfigurationFromHibernateCore searchConfig = new SearchConfigurationFromHibernateCore(this.getCfg(), (ClassLoaderService)new ClassLoaderServiceImpl());
        ReflectionManager reflectionManager = searchConfig.getReflectionManager();
        XClass xclass = reflectionManager.toXClass(BlogEntry.class);
        ConfigContext context = new ConfigContext((SearchConfiguration)searchConfig, (BuildContext)new BuildContextForTest((SearchConfiguration)searchConfig));
        AnnotationMetadataProvider metadataProvider = new AnnotationMetadataProvider(searchConfig.getReflectionManager(), context);
        try {
            metadataProvider.getTypeMetadataFor(reflectionManager.toClass(xclass));
            Assert.fail();
        }
        catch (SearchException e) {
            Assert.assertTrue((String)"Wrong error message", (boolean)e.getMessage().startsWith("Multiple AnalyzerDiscriminator defined in the same class hierarchy"));
        }
    }

    @Test
    public void testScopedAnalyzers() throws Exception {
        MyEntity en = new MyEntity();
        en.setEntity("Entity");
        en.setField("Field");
        en.setProperty("Property");
        en.setComponent(new MyComponent());
        en.getComponent().setComponentProperty("component property");
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        s.persist((Object)en);
        tx.commit();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "id", TestConstants.standardAnalyzer);
        Query luceneQuery = parser.parse("entity:alarm");
        FullTextQuery query = s.createFullTextQuery(luceneQuery, new Class[]{MyEntity.class});
        Assert.assertEquals((long)1L, (long)query.getResultSize());
        luceneQuery = parser.parse("property:cat");
        query = s.createFullTextQuery(luceneQuery, new Class[]{MyEntity.class});
        Assert.assertEquals((long)1L, (long)query.getResultSize());
        luceneQuery = parser.parse("field:energy");
        query = s.createFullTextQuery(luceneQuery, new Class[]{MyEntity.class});
        Assert.assertEquals((long)1L, (long)query.getResultSize());
        luceneQuery = parser.parse("component.componentProperty:noise");
        query = s.createFullTextQuery(luceneQuery, new Class[]{MyEntity.class});
        Assert.assertEquals((long)1L, (long)query.getResultSize());
        s.delete(query.uniqueResult());
        tx.commit();
        s.close();
    }

    @Test
    public void testScopedAnalyzersFromSearchFactory() throws Exception {
        FullTextSession session = Search.getFullTextSession((Session)this.openSession());
        SearchFactory searchFactory = session.getSearchFactory();
        Analyzer analyzer = searchFactory.getAnalyzer(MyEntity.class);
        Token[] tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"entity", (String)"");
        AnalyzerTest.assertTokensEqual(tokens, new String[]{"alarm", "dog", "performance"});
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"property", (String)"");
        AnalyzerTest.assertTokensEqual(tokens, new String[]{"sound", "cat", "speed"});
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"field", (String)"");
        AnalyzerTest.assertTokensEqual(tokens, new String[]{"music", "elephant", "energy"});
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"component.componentProperty", (String)"");
        AnalyzerTest.assertTokensEqual(tokens, new String[]{"noise", "mouse", "light"});
        try {
            searchFactory.getAnalyzer((Class)null);
        }
        catch (IllegalArgumentException iae) {
            log.debug((Object)"success");
        }
        try {
            searchFactory.getAnalyzer(String.class);
        }
        catch (IllegalArgumentException iae) {
            log.debug((Object)"success");
        }
        session.close();
    }

    @Test
    public void testNotAnalyzedFieldAndScopedAnalyzer() throws Exception {
        FullTextSession session = Search.getFullTextSession((Session)this.openSession());
        SearchFactory searchFactory = session.getSearchFactory();
        Analyzer analyzer = searchFactory.getAnalyzer(MyEntity.class);
        Token[] tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"notAnalyzed", (String)"pass through");
        AnalyzerTest.assertTokensEqual(tokens, new String[]{"pass through"});
        session.close();
    }

    public static void assertTokensEqual(Token[] tokens, String[] strings) {
        Assert.assertEquals((long)strings.length, (long)tokens.length);
        for (int i = 0; i < tokens.length; ++i) {
            Assert.assertEquals((String)("index " + i), (Object)strings[i], (Object)AnalyzerUtils.getTermText((Token)tokens[i]));
        }
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{MyEntity.class, Article.class};
    }
}

