/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge.provider;

import java.util.List;
import org.apache.lucene.search.Query;
import org.fest.assertions.Assertions;
import org.fest.assertions.ListAssert;
import org.hibernate.Session;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.bridge.provider.Chain;
import org.hibernate.search.test.bridge.provider.Movie;
import org.hibernate.search.test.bridge.provider.Theater;
import org.hibernate.search.test.util.HibernateManualConfiguration;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Test;

public class BridgeProviderTest
extends SearchTestBase {
    @Test
    public void testCustomBridgeProvider() {
        Session s = this.openSession();
        s.getTransaction().begin();
        Movie laConfidential = new Movie("LA Confidential");
        Theater legendary = new Theater("Legendary theater", laConfidential);
        s.persist((Object)laConfidential);
        s.persist((Object)legendary);
        s.getTransaction().commit();
        s.clear();
        s.getTransaction().begin();
        FullTextSession fts = Search.getFullTextSession((Session)s);
        QueryBuilder qb = fts.getSearchFactory().buildQueryBuilder().forEntity(Theater.class).get();
        Query query = qb.keyword().onField("movie").matching((Object)laConfidential).createQuery();
        ((ListAssert)Assertions.assertThat((List)fts.createFullTextQuery(query, new Class[]{Theater.class}).list()).as("The SearchFactory should build and find a bridge for Movie in Theater and  properly use it for indexing")).hasSize(1);
        s.getTransaction().commit();
        s.clear();
        s.getTransaction().begin();
        for (Object o : s.createQuery("from java.lang.Object o").list()) {
            s.delete(o);
        }
        s.getTransaction().commit();
    }

    @Test
    public void testMultipleMatchingFieldBridges() throws Exception {
        SearchConfigurationForTest conf = new HibernateManualConfiguration().addClass(Theater.class).addClass(Chain.class);
        boolean throwException = false;
        try {
            SearchFactoryImplementor sf = new SearchFactoryBuilder().configuration((SearchConfiguration)conf).buildSearchFactory();
            sf.close();
        }
        catch (SearchException e) {
            Assertions.assertThat((String)e.getMessage()).contains("TheaterBridgeProvider1");
            throwException = true;
        }
        Assertions.assertThat((boolean)throwException).isTrue();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Movie.class, Theater.class};
    }
}

