/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.CachingWrapperFilter;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.OpenBitSet;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.annotations.Key;
import org.hibernate.search.filter.FilterKey;
import org.hibernate.search.filter.StandardFilterKey;

public class SecurityFilterFactory {
    private String ownerName;

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    @Factory
    public Filter buildSecurityFilter() {
        SecurityFilter securityFilter = new SecurityFilter(this.ownerName);
        return new CachingWrapperFilter((Filter)securityFilter);
    }

    @Key
    public FilterKey getKey() {
        StandardFilterKey key = new StandardFilterKey();
        key.addParameter((Object)this.ownerName);
        return key;
    }

    private static final class SecurityFilter
    extends Filter {
        private final String ownerName;

        private SecurityFilter(String ownerName) {
            this.ownerName = ownerName;
        }

        public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
            AtomicReader reader = context.reader();
            OpenBitSet bitSet = new OpenBitSet((long)reader.maxDoc());
            DocsEnum termDocsEnum = reader.termDocsEnum(new Term("owner", this.ownerName));
            if (termDocsEnum == null) {
                return bitSet;
            }
            while (termDocsEnum.nextDoc() != Integer.MAX_VALUE) {
                int docID = termDocsEnum.docID();
                if (acceptDocs != null && !acceptDocs.get(docID)) continue;
                bitSet.set((long)docID);
            }
            return bitSet;
        }
    }
}

