/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.directoryProvider;

import java.io.File;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.hibernate.search.test.directoryProvider.FSSlaveAndMasterDPTest;
import org.hibernate.search.test.directoryProvider.FSSlaveDirectoryProviderTestingExtension;
import org.hibernate.search.test.directoryProvider.SnowStorm;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RetryInitializeTest {
    private FullTextSessionBuilder slave;
    private FullTextSessionBuilder master;
    private File root;

    @Before
    public void setUp() throws Exception {
        this.root = FSSlaveAndMasterDPTest.prepareDirectories(this.getClass().getSimpleName());
    }

    @After
    public void tearDown() throws Exception {
        if (this.slave != null) {
            this.slave.close();
        }
        if (this.master != null) {
            this.master.close();
        }
        FSSlaveAndMasterDPTest.cleanupDirectories(this.root);
    }

    @Test
    public void testStandardInitialization() {
        this.master = this.createMasterNode();
        this.slave = this.createSlaveNode(false);
    }

    @Test(expected=SearchException.class)
    public void testInitiallyFailing() {
        this.slave = this.createSlaveNode(false);
    }

    @Test
    public void testMasterDelayedInitialization() {
        this.slave = this.createSlaveNode(true);
        Assert.assertNotNull((Object)FSSlaveDirectoryProviderTestingExtension.taskScheduled);
        Long scheduledPeriod = FSSlaveDirectoryProviderTestingExtension.taskScheduledPeriod;
        Assert.assertNotNull((Object)scheduledPeriod);
        Assert.assertEquals((Object)12000L, (Object)scheduledPeriod);
        SearchFactoryIntegrator searchFactory = (SearchFactoryIntegrator)this.slave.getSearchFactory();
        EntityIndexBinding snowIndexBinder = searchFactory.getIndexBinding(SnowStorm.class);
        IndexManager[] indexManagers = snowIndexBinder.getIndexManagers();
        Assert.assertEquals((long)1L, (long)indexManagers.length);
        DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)indexManagers[0];
        FSSlaveDirectoryProviderTestingExtension dp = (FSSlaveDirectoryProviderTestingExtension)indexManager.getDirectoryProvider();
        Directory directory = dp.getDirectory();
        Assert.assertTrue((boolean)(directory instanceof RAMDirectory));
        dp.triggerTimerAction();
        directory = dp.getDirectory();
        Assert.assertTrue((boolean)(directory instanceof RAMDirectory));
        this.master = this.createMasterNode();
        dp.triggerTimerAction();
        directory = dp.getDirectory();
        Assert.assertTrue((boolean)(directory instanceof FSDirectory));
    }

    private FullTextSessionBuilder createMasterNode() {
        return new FullTextSessionBuilder().addAnnotatedClass(SnowStorm.class).setProperty("hibernate.search.default.sourceBase", this.root.getAbsolutePath() + "/master/copy").setProperty("hibernate.search.default.indexBase", this.root.getAbsolutePath() + "/master/main").setProperty("hibernate.search.default.directory_provider", "filesystem-master").build();
    }

    private FullTextSessionBuilder createSlaveNode(boolean enableRetryInitializePeriod) {
        FullTextSessionBuilder builder = new FullTextSessionBuilder().addAnnotatedClass(SnowStorm.class).setProperty("hibernate.search.default.sourceBase", this.root.getAbsolutePath() + "/master/copy").setProperty("hibernate.search.default.indexBase", this.root.getAbsolutePath() + "/slave").setProperty("hibernate.search.default.directory_provider", FSSlaveDirectoryProviderTestingExtension.class.getName());
        if (enableRetryInitializePeriod) {
            builder.setProperty("hibernate.search.default.retry_initialize_period", "12");
        }
        return builder.build();
    }
}

