/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.shards;

import java.util.List;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.shards.Email;
import org.hibernate.search.test.shards.SpecificShardingStrategy;
import org.hibernate.search.testsupport.TestConstants;
import org.junit.Assert;
import org.junit.Test;

public class DirectoryProviderForQueryTest
extends SearchTestBase {
    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.Email.sharding_strategy", SpecificShardingStrategy.class.getCanonicalName());
        cfg.setProperty("hibernate.search.Email.sharding_strategy.nbr_of_shards", "2");
    }

    @Test
    public void testDirectoryProviderForQuery() throws Exception {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        Email a = new Email();
        a.setId(1);
        a.setBody("corporate message");
        s.persist((Object)a);
        a = new Email();
        a.setId(2);
        a.setBody("spam message");
        s.persist((Object)a);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        FullTextSession fts = Search.getFullTextSession((Session)s);
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "id", TestConstants.stopAnalyzer);
        FullTextQuery fullTextQuery = fts.createFullTextQuery(parser.parse("body:message"), new Class[0]);
        List results = fullTextQuery.list();
        Assert.assertEquals((String)"Query with no filter should bring back results from both shards.", (long)2L, (long)results.size());
        fullTextQuery.enableFullTextFilter("shard").setParameter("index", (Object)0);
        Assert.assertEquals((String)"Query with filter should bring back results from only one shard.", (long)1L, (long)fullTextQuery.list().size());
        for (Object o : results) {
            s.delete(o);
        }
        tx.commit();
        s.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Email.class};
    }
}

