/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.similarity;

import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.similarity.Can;
import org.hibernate.search.test.similarity.DummySimilarity2;
import org.junit.Assert;
import org.junit.Test;

public class SimilarityTest
extends SearchTestBase {
    @Test
    public void testConfiguredDefaultSimilarityGetsApplied() throws Exception {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        Can can = new Can();
        can.setName("Green can");
        s.persist((Object)can);
        can = new Can();
        can.setName("Green Green Green can");
        s.persist((Object)can);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        TermQuery termQuery = new TermQuery(new Term("name", "green"));
        FullTextSession fullTextSession = Search.getFullTextSession((Session)s);
        List results = fullTextSession.createFullTextQuery((Query)termQuery, new Class[]{Can.class}).setProjection(new String[]{"__HSearch_Score", "__HSearch_This"}).list();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((String)"Similarity not overridden by the global setting", (Object)((Object[])results.get(0))[0], (Object)((Object[])results.get(1))[0]);
        Assert.assertFalse((String)"Similarity not overridden by the global setting", (boolean)new Float(1.0f).equals(((Object[])results.get(0))[0]));
        tx.commit();
        s.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Can.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        cfg.setProperty("hibernate.search.similarity", DummySimilarity2.class.getName());
        super.configure(cfg);
    }
}

