/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test;

import java.io.File;
import org.apache.lucene.store.Directory;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.engine.integration.impl.SearchFactoryImplementor;
import org.hibernate.search.test.DefaultTestResourceManager;
import org.hibernate.search.test.TestResourceManager;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.testing.junit4.CustomRunner;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;

@RunWith(value=CustomRunner.class)
public abstract class SearchTestBase
implements TestResourceManager {
    protected static final Boolean PERFORMANCE_TESTS_ENABLED = TestConstants.arePerformanceTestsEnabled();
    private DefaultTestResourceManager testResourceManager;

    @Before
    public void setUp() throws Exception {
        DefaultTestResourceManager testResourceManager = this.getTestResourceManager();
        if (testResourceManager.needsConfigurationRebuild()) {
            this.configure(testResourceManager.getCfg());
            testResourceManager.buildConfiguration();
        }
        testResourceManager.openSessionFactory();
    }

    @After
    public void tearDown() throws Exception {
        this.getTestResourceManager().defaultTearDown();
    }

    @Override
    public final Configuration getCfg() {
        return this.getTestResourceManager().getCfg();
    }

    @Override
    public final void openSessionFactory() {
        this.getTestResourceManager().openSessionFactory();
    }

    @Override
    public final void closeSessionFactory() {
        this.getTestResourceManager().closeSessionFactory();
    }

    @Override
    public final SessionFactory getSessionFactory() {
        return this.getTestResourceManager().getSessionFactory();
    }

    @Override
    public final SearchFactory getSearchFactory() {
        return this.getTestResourceManager().getSearchFactory();
    }

    public SearchFactoryImplementor getSearchFactoryImpl() {
        return this.getTestResourceManager().getSearchFactoryImpl();
    }

    @Override
    public final Session openSession() {
        return this.getTestResourceManager().openSession();
    }

    @Override
    public final Session getSession() {
        return this.getTestResourceManager().getSession();
    }

    @Override
    public void ensureIndexesAreEmpty() {
        this.getTestResourceManager().ensureIndexesAreEmpty();
    }

    @Override
    public File getBaseIndexDir() {
        return this.getTestResourceManager().getBaseIndexDir();
    }

    @Override
    public Directory getDirectory(Class<?> clazz) {
        return this.getTestResourceManager().getDirectory(clazz);
    }

    @Override
    public void forceConfigurationRebuild() {
        this.getTestResourceManager().forceConfigurationRebuild();
    }

    @Override
    public boolean needsConfigurationRebuild() {
        return this.getTestResourceManager().needsConfigurationRebuild();
    }

    protected abstract Class<?>[] getAnnotatedClasses();

    protected void configure(Configuration cfg) {
        this.getTestResourceManager().applyDefaultConfiguration(cfg);
    }

    private synchronized DefaultTestResourceManager getTestResourceManager() {
        if (this.testResourceManager == null) {
            this.testResourceManager = new DefaultTestResourceManager(this.getAnnotatedClasses());
        }
        return this.testResourceManager;
    }
}

