/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.batchindexing;

import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.engine.integration.impl.SearchFactoryImplementor;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.batchindexing.Book;
import org.hibernate.search.test.batchindexing.MassIndexerErrorReportingTest;
import org.hibernate.search.test.batchindexing.Nation;
import org.hibernate.search.test.errorhandling.MockErrorHandler;
import org.hibernate.testing.RequiresDialect;
import org.junit.Assert;
import org.junit.Test;

public class FetchSizeConfigurationTest
extends SearchTestBase {
    @Test
    @RequiresDialect(comment="H2 does not accept negative fetch sizes", strictMatching=true, value={H2Dialect.class})
    public void testSetFetchSizeOnH2Fails() throws InterruptedException {
        SearchFactoryImplementor searchIntegrator = this.getSearchFactoryImpl();
        MockErrorHandler mockErrorHandler = MassIndexerErrorReportingTest.getErrorHandler((SearchIntegrator)searchIntegrator);
        FullTextSession fullTextSession = MassIndexerErrorReportingTest.prepareSomeData(this);
        fullTextSession.createIndexer(new Class[]{Book.class}).idFetchSize(-1).startAndWait();
        this.getSession().close();
        String errorMessage = mockErrorHandler.getErrorMessage();
        Assert.assertEquals((Object)"HSEARCH000211: An exception occurred while the MassIndexer was fetching the primary identifiers list", (Object)errorMessage);
        Throwable exception = mockErrorHandler.getLastException();
        Assert.assertTrue((boolean)(exception instanceof GenericJDBCException));
    }

    @Test
    @RequiresDialect(comment="MySQL definitely should accept Integer.MIN_VALUE", strictMatching=false, value={MySQLDialect.class})
    public void testSetFetchSizeOnMySQL() throws InterruptedException {
        SearchFactoryImplementor searchIntegrator = this.getSearchFactoryImpl();
        MockErrorHandler mockErrorHandler = MassIndexerErrorReportingTest.getErrorHandler((SearchIntegrator)searchIntegrator);
        FullTextSession fullTextSession = MassIndexerErrorReportingTest.prepareSomeData(this);
        fullTextSession.createIndexer(new Class[]{Book.class}).idFetchSize(Integer.MIN_VALUE).startAndWait();
        this.getSession().close();
        String errorMessage = mockErrorHandler.getErrorMessage();
        Assert.assertEquals(null, (Object)errorMessage);
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Book.class, Nation.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.error_handler", MockErrorHandler.class.getName());
    }
}

