/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.fieldbridgeonlazyfield;

import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.MassIndexer;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.embedded.fieldbridgeonlazyfield.LazyItem;
import org.hibernate.search.test.embedded.fieldbridgeonlazyfield.Leaf;
import org.hibernate.search.test.embedded.fieldbridgeonlazyfield.Root;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1201")
public class FieldBridgeOnLazyFieldReindexTest
extends SearchTestBase {
    @Test
    public void testFieldBridgeOnLazyFieldReindexTest() throws InterruptedException {
        this.prepareEntities();
        this.verifyMatchExistsWithName("name", "name");
        Session session = this.openSession();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        MassIndexer massIndexer = fullTextSession.createIndexer(new Class[]{Root.class});
        massIndexer.startAndWait();
        this.verifyMatchExistsWithName("name", "name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyMatchExistsWithName(String fieldName, String fieldValue) {
        try (FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());){
            Transaction transaction = fullTextSession.beginTransaction();
            TermQuery q = new TermQuery(new Term(fieldName, fieldValue));
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)q, new Class[0]);
            int resultSize = fullTextQuery.getResultSize();
            Assert.assertEquals((long)1L, (long)resultSize);
            List list = fullTextQuery.list();
            Assert.assertEquals((long)1L, (long)list.size());
            transaction.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareEntities() {
        try (Session session = this.openSession();){
            Transaction transaction = session.beginTransaction();
            LazyItem bridgedEntity = new LazyItem();
            session.save((Object)bridgedEntity);
            Leaf leaf = new Leaf();
            leaf.setLazyItem(bridgedEntity);
            session.save((Object)leaf);
            Root root = new Root();
            root.setName("name");
            root.setLeaf(leaf);
            session.save((Object)root);
            transaction.commit();
        }
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{LazyItem.class, Leaf.class, Root.class};
    }
}

