/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.dsl;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.fest.assertions.Assertions;
import org.fest.assertions.CollectionAssert;
import org.fest.assertions.Condition;
import org.fest.assertions.ObjectAssert;
import org.fest.assertions.StringAssert;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.dsl.MoreLikeThisOpenedMatchingContext;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.query.dsl.Coffee;
import org.hibernate.search.test.query.dsl.CoffeeBrand;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MoreLikeThisTest
extends SearchTestBase {
    private static final Log log = LoggerFactory.make();
    private FullTextSession fullTextSession;
    private boolean outputLogs = false;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Session session = this.openSession();
        this.fullTextSession = Search.getFullTextSession((Session)session);
        this.indexTestData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoreLikeThisBasicBehavior() {
        Transaction transaction = this.fullTextSession.beginTransaction();
        try {
            QueryBuilder qb = this.getCoffeeQueryBuilder();
            Coffee decaffInstance = this.getDecaffInstance(qb);
            Query mltQuery = qb.moreLikeThis().favorSignificantTermsWithFactor(1.0f).comparingAllFields().toEntityWithId((Object)decaffInstance.getId()).createQuery();
            List results = this.fullTextSession.createFullTextQuery(mltQuery, new Class[]{Coffee.class}).setProjection(new String[]{"__HSearch_This", "__HSearch_Score"}).list();
            Assertions.assertThat((List)results).isNotEmpty();
            HashSet terms = new HashSet(100);
            mltQuery.extractTerms(terms);
            ((CollectionAssert)Assertions.assertThat(terms).describedAs("internalDescription should be ignored")).doesNotSatisfy(new Condition<Collection<?>>(){

                public boolean matches(Collection<?> value) {
                    for (Term term : value) {
                        if (!"internalDescription".equals(term.field())) continue;
                        return true;
                    }
                    return false;
                }
            });
            this.outputQueryAndResults(decaffInstance, mltQuery, results);
            mltQuery = ((MoreLikeThisOpenedMatchingContext)qb.moreLikeThis().comparingField("summary").boostedTo(10.0f)).andField("description").toEntityWithId((Object)decaffInstance.getId()).createQuery();
            results = this.fullTextSession.createFullTextQuery(mltQuery, new Class[]{Coffee.class}).setProjection(new String[]{"__HSearch_This", "__HSearch_Score"}).list();
            Assertions.assertThat((List)results).isNotEmpty();
            Assertions.assertThat((boolean)(mltQuery instanceof BooleanQuery));
            BooleanQuery topMltQuery = (BooleanQuery)mltQuery;
            Assertions.assertThat((Object[])topMltQuery.getClauses()).onProperty("query.boost").contains(new Object[]{Float.valueOf(1.0f), Float.valueOf(10.0f)});
            this.outputQueryAndResults(decaffInstance, mltQuery, results);
            try {
                qb.moreLikeThis().comparingField("summary").andField("internalDescription").toEntityWithId((Object)decaffInstance.getId()).createQuery();
            }
            catch (SearchException e) {
                ((StringAssert)Assertions.assertThat((String)e.getMessage()).as("Internal description is neither stored nor store termvectors")).contains("internalDescription");
            }
        }
        finally {
            transaction.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoreLikeThisToEntity() {
        Transaction transaction = this.fullTextSession.beginTransaction();
        try {
            Object[] expected;
            Object[] real;
            int index;
            QueryBuilder qb = this.getCoffeeQueryBuilder();
            Coffee decaffInstance = this.getDecaffInstance(qb);
            Query mltQuery = ((MoreLikeThisOpenedMatchingContext)qb.moreLikeThis().comparingField("summary").boostedTo(10.0f)).andField("description").toEntityWithId((Object)decaffInstance.getId()).createQuery();
            List results = this.fullTextSession.createFullTextQuery(mltQuery, new Class[]{Coffee.class}).setProjection(new String[]{"__HSearch_This", "__HSearch_Score"}).list();
            mltQuery = ((MoreLikeThisOpenedMatchingContext)qb.moreLikeThis().comparingField("summary").boostedTo(10.0f)).andField("description").toEntity((Object)decaffInstance).createQuery();
            List entityResults = this.fullTextSession.createFullTextQuery(mltQuery, new Class[]{Coffee.class}).setProjection(new String[]{"__HSearch_This", "__HSearch_Score"}).list();
            Assertions.assertThat((List)entityResults).isNotEmpty();
            Assertions.assertThat((List)entityResults).hasSize(results.size());
            for (int index2 = 0; index2 < entityResults.size(); ++index2) {
                Object[] real2 = (Object[])entityResults.get(index2);
                Object[] expected2 = (Object[])results.get(index2);
                Assertions.assertThat((Object)real2[1]).isEqualTo(expected2[1]);
                Assertions.assertThat((Integer)((Coffee)real2[0]).getId()).isEqualTo((Object)((Coffee)expected2[0]).getId());
            }
            this.outputQueryAndResults(decaffInstance, mltQuery, entityResults);
            Coffee nonMatchingOne = (Coffee)((Object[])results.get(results.size() - 1))[0];
            Coffee copyOfDecaffInstance = new Coffee();
            copyOfDecaffInstance.setId(decaffInstance.getId());
            copyOfDecaffInstance.setInternalDescription(nonMatchingOne.getInternalDescription());
            copyOfDecaffInstance.setName(nonMatchingOne.getName());
            copyOfDecaffInstance.setDescription(nonMatchingOne.getDescription());
            copyOfDecaffInstance.setIntensity(nonMatchingOne.getIntensity());
            copyOfDecaffInstance.setSummary(nonMatchingOne.getSummary());
            mltQuery = ((MoreLikeThisOpenedMatchingContext)qb.moreLikeThis().comparingField("summary").boostedTo(10.0f)).andField("description").toEntity((Object)copyOfDecaffInstance).createQuery();
            entityResults = this.fullTextSession.createFullTextQuery(mltQuery, new Class[]{Coffee.class}).setProjection(new String[]{"__HSearch_This", "__HSearch_Score"}).list();
            Assertions.assertThat((List)entityResults).isNotEmpty();
            Assertions.assertThat((List)entityResults).hasSize(results.size());
            for (index = 0; index < entityResults.size(); ++index) {
                real = (Object[])entityResults.get(index);
                expected = (Object[])results.get(index);
                Assertions.assertThat((Object)real[1]).isEqualTo(expected[1]);
                Assertions.assertThat((Integer)((Coffee)real[0]).getId()).isEqualTo((Object)((Coffee)expected[0]).getId());
            }
            this.outputQueryAndResults(decaffInstance, mltQuery, entityResults);
            copyOfDecaffInstance = new Coffee();
            copyOfDecaffInstance.setInternalDescription(decaffInstance.getInternalDescription());
            copyOfDecaffInstance.setName(decaffInstance.getName());
            copyOfDecaffInstance.setDescription(decaffInstance.getDescription());
            copyOfDecaffInstance.setIntensity(decaffInstance.getIntensity());
            copyOfDecaffInstance.setSummary(decaffInstance.getSummary());
            mltQuery = ((MoreLikeThisOpenedMatchingContext)qb.moreLikeThis().comparingField("summary").boostedTo(10.0f)).andField("description").toEntity((Object)copyOfDecaffInstance).createQuery();
            entityResults = this.fullTextSession.createFullTextQuery(mltQuery, new Class[]{Coffee.class}).setProjection(new String[]{"__HSearch_This", "__HSearch_Score"}).list();
            Assertions.assertThat((List)entityResults).isNotEmpty();
            Assertions.assertThat((List)entityResults).hasSize(results.size());
            for (index = 0; index < entityResults.size(); ++index) {
                real = (Object[])entityResults.get(index);
                expected = (Object[])results.get(index);
                Assertions.assertThat((Object)real[1]).isEqualTo(expected[1]);
                Assertions.assertThat((Integer)((Coffee)real[0]).getId()).isEqualTo((Object)((Coffee)expected[0]).getId());
            }
            this.outputQueryAndResults(decaffInstance, mltQuery, entityResults);
        }
        finally {
            transaction.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoreLikeThisExcludingEntityBeingCompared() {
        Transaction transaction = this.fullTextSession.beginTransaction();
        try {
            QueryBuilder qb = this.getCoffeeQueryBuilder();
            Coffee decaffInstance = this.getDecaffInstance(qb);
            Query mltQuery = ((MoreLikeThisOpenedMatchingContext)qb.moreLikeThis().comparingField("summary").boostedTo(10.0f)).andField("description").toEntityWithId((Object)decaffInstance.getId()).createQuery();
            List results = this.fullTextSession.createFullTextQuery(mltQuery, new Class[]{Coffee.class}).setProjection(new String[]{"__HSearch_This", "__HSearch_Score"}).list();
            mltQuery = ((MoreLikeThisOpenedMatchingContext)qb.moreLikeThis().excludeEntityUsedForComparison().comparingField("summary").boostedTo(10.0f)).andField("description").toEntityWithId((Object)decaffInstance.getId()).createQuery();
            List resultsWoComparingEntity = this.fullTextSession.createFullTextQuery(mltQuery, new Class[]{Coffee.class}).setProjection(new String[]{"__HSearch_This", "__HSearch_Score"}).list();
            Assertions.assertThat((List)resultsWoComparingEntity).hasSize(results.size() - 1);
            for (int index = 0; index < resultsWoComparingEntity.size(); ++index) {
                Object[] real = (Object[])resultsWoComparingEntity.get(index);
                Object[] expected = (Object[])results.get(index + 1);
                Assertions.assertThat((Object)real[1]).isEqualTo(expected[1]);
                Assertions.assertThat((Integer)((Coffee)real[0]).getId()).isEqualTo((Object)((Coffee)expected[0]).getId());
            }
            this.outputQueryAndResults(decaffInstance, mltQuery, resultsWoComparingEntity);
        }
        finally {
            transaction.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoreLikeThisOnCompressedFields() {
        Transaction transaction = this.fullTextSession.beginTransaction();
        try {
            QueryBuilder qb = this.getCoffeeQueryBuilder();
            Coffee decaffInstance = this.getDecaffInstance(qb);
            Query mltQuery = qb.moreLikeThis().comparingField("brand.description").toEntityWithId((Object)decaffInstance.getId()).createQuery();
            List entityResults = this.fullTextSession.createFullTextQuery(mltQuery, new Class[]{Coffee.class}).setProjection(new String[]{"__HSearch_This", "__HSearch_Score"}).list();
            Assertions.assertThat((List)entityResults).isNotEmpty();
            Long matchingElements = (Long)this.fullTextSession.createQuery("select count(*) from Coffee c where c.brand.name like '%pony'").uniqueResult();
            Assertions.assertThat((List)entityResults).hasSize(matchingElements.intValue());
            float score = -1.0f;
            for (Object[] element : entityResults) {
                if (score == -1.0f) {
                    score = ((Float)element[1]).floatValue();
                }
                ((ObjectAssert)Assertions.assertThat((Object)element[1]).as("All scores should be equal as the same brand is used")).isEqualTo((Object)Float.valueOf(score));
            }
            this.outputQueryAndResults(decaffInstance, mltQuery, entityResults);
        }
        finally {
            transaction.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoreLikeThisOnEmbeddedFields() {
        Transaction transaction = this.fullTextSession.beginTransaction();
        try {
            QueryBuilder qb = this.getCoffeeQueryBuilder();
            Coffee decaffInstance = this.getDecaffInstance(qb);
            Query mltQuery = qb.moreLikeThis().comparingField("brand.name").toEntityWithId((Object)decaffInstance.getId()).createQuery();
            List entityResults = this.fullTextSession.createFullTextQuery(mltQuery, new Class[]{Coffee.class}).setProjection(new String[]{"__HSearch_This", "__HSearch_Score"}).list();
            Assertions.assertThat((List)entityResults).isNotEmpty();
            Long matchingElements = (Long)this.fullTextSession.createQuery("select count(*) from Coffee c where c.brand.name like '%pony'").uniqueResult();
            Assertions.assertThat((List)entityResults).hasSize(matchingElements.intValue());
            float score = -1.0f;
            for (Object[] element : entityResults) {
                if (score == -1.0f) {
                    score = ((Float)element[1]).floatValue();
                }
                ((ObjectAssert)Assertions.assertThat((Object)element[1]).as("All scores should be equal as the same brand is used")).isEqualTo((Object)Float.valueOf(score));
            }
            this.outputQueryAndResults(decaffInstance, mltQuery, entityResults);
            try {
                qb.moreLikeThis().comparingField("brand.id").toEntityWithId((Object)decaffInstance.getId()).createQuery();
            }
            catch (SearchException e) {
                ((StringAssert)Assertions.assertThat((String)e.getMessage()).as("Field cannot be used")).contains("brand.id");
            }
        }
        finally {
            transaction.commit();
        }
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1614")
    public void testMoreLikeThisOnUnknownFieldThrowsException() {
        QueryBuilder queryBuilder = this.getCoffeeQueryBuilder();
        Coffee decaffInstance = this.getDecaffInstance(queryBuilder);
        try {
            queryBuilder.moreLikeThis().comparingField("foo").toEntityWithId((Object)decaffInstance.getId()).createQuery();
            Assert.fail((String)"Creating the query should have failed");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected error message: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000218"));
        }
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Coffee.class, CoffeeBrand.class};
    }

    private QueryBuilder getCoffeeQueryBuilder() {
        return this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Coffee.class).get();
    }

    private Coffee getDecaffInstance(QueryBuilder qb) {
        Query decaff = qb.keyword().onField("name").matching((Object)"Decaffeinato").createQuery();
        return (Coffee)this.fullTextSession.createFullTextQuery(decaff, new Class[]{Coffee.class}).list().get(0);
    }

    private void outputQueryAndResults(Coffee originalInstance, Query mltQuery, List<Object[]> results) {
        if (this.outputLogs) {
            StringBuilder builder = new StringBuilder("Initial coffee: ").append(originalInstance).append("\n\n").append("Query: ").append(mltQuery.toString()).append("\n\n").append("Matching coffees").append("\n");
            for (Object[] entry : results) {
                builder.append("    Score: ").append(entry[1]);
                builder.append(" | Coffee: ").append(entry[0]).append("\n");
            }
            log.debug((Object)builder.toString());
        }
    }

    private void indexTestData() {
        Transaction tx = this.fullTextSession.beginTransaction();
        CoffeeBrand brandPony = new CoffeeBrand();
        brandPony.setName("My little pony");
        brandPony.setDescription("Sells goods for horseback riding and good coffee blends");
        this.fullTextSession.persist((Object)brandPony);
        CoffeeBrand brandMonkey = new CoffeeBrand();
        brandMonkey.setName("Monkey Monkey Do");
        brandPony.setDescription("Offers mover services via monkeys instead of trucks for difficult terrains. Coffees from this brand make monkeys work much faster.");
        this.fullTextSession.persist((Object)brandMonkey);
        this.createCoffee("Kazaar", "EXCEPTIONALLY INTENSE AND SYRUPY", "A daring blend of two Robustas from Brazil and Guatemala, specially prepared for Nespresso, and a separately roasted Arabica from South America, Kazaar is a coffee of exceptional intensity. Its powerful bitterness and notes of pepper are balanced by a full and creamy texture.", 12, brandMonkey);
        this.createCoffee("Dharkan", "LONG ROASTED AND VELVETY", "This blend of Arabicas from Latin America and Asia fully unveils its character thanks to the technique of long roasting at a low temperature. Its powerful personality reveals intense roasted notes together with hints of bitter cocoa powder and toasted cereals that express themselves in a silky and velvety txture.", 11, brandPony);
        this.createCoffee("Ristretto", "POWERFUL AND CONTRASTING", "A blend of South American and East African Arabicas, with a touch of Robusta, roasted separately to create the subtle fruity note of this full-bodied, intense espresso.", 10, brandMonkey);
        this.createCoffee("Arpeggio", "INTENSE AND CREAMY", "A dark roast of pure South and Central American Arabicas, Arpeggio has a strong character and intense body, enhanced by cocoa notes.", 9, brandPony);
        this.createCoffee("Roma", "FULL AND BALANCED", "The balance of lightly roasted South and Central American Arabicas with Robusta, gives Roma sweet and woody notes and a full, lasting taste on the palate.", 8, brandMonkey);
        this.createCoffee("Livanto", "ROUND AND BALANCED", "A pure Arabica from South and Central America, Livanto is a well-balanced espresso characterised by a roasted caramelised note.", 6, brandMonkey);
        this.createCoffee("Capriccio", "RICH AND DISTINCTIVE", "Blending South American Arabicas with a touch of Robusta, Capriccio is an espresso with a rich aroma and a strong typical cereal note.", 5, brandMonkey);
        this.createCoffee("Volluto", "SWEET AND LIGHT", "A pure and lightly roasted Arabica from South America, Volluto reveals sweet and biscuity flavours, reinforced by a little acidity and a fruity note.", 4, brandMonkey);
        this.createCoffee("Cosi", "LIGHT AND LEMONY", "Pure, lightly roasted East African, Central and South American Arabicas make Cosi a light-bodied espresso with refreshing citrus notes.", 3, brandMonkey);
        this.createCoffee("Indriya from India", "POWERFUL AND SPICY", "Indriya from India is the noble marriage of Arabicas with a hint of Robusta from southern India. It is a full-bodied espresso, which has a distinct personality with notes of spices.", 10, brandMonkey);
        this.createCoffee("Rosabaya de Colombia", "FRUITY AND BALANCED", "This blend of fine, individually roasted Colombian Arabicas, develops a subtle acidity with typical red fruit and winey notes.", 6, brandMonkey);
        this.createCoffee("Duls\u00e3o do Brasil", "SWEET AND SATINY SMOOTH", "A pure Arabica coffee, Duls\u00e3o do Brasil is a delicate blend of red and yellow Bourbon beans from Brazil. Its satiny smooth, elegantly balanced flavor is enhanced with a note of delicately toasted grain.", 4, brandMonkey);
        this.createCoffee("Bukeela ka Ethiopia", "", "This delicate Lungo expresses a floral bouquet reminiscent of jasmine, white lily, bergamot and orange blossom together with notes of wood. A pure Arabica blend composed of two very different coffees coming from the birthplace of coffee, Ethiopia. The blend\u2019s coffees are roasted separately: one portion short and dark to guarantee the body, the other light but longer to preserve the delicate notes.", 3, brandMonkey);
        this.createCoffee("Fortissio Lungo", "RICH AND INTENSE", "Made from Central and South American Arabicas with just a hint of Robusta, Fortissio Lungo is an intense full-bodied blend with bitterness, which develops notes of dark roasted beans.", 7, brandMonkey);
        this.createCoffee("Vivalto Lungo", "COMPLEX AND BALANCED", "Vivalto Lungo is a balanced coffee made from a complex blend of separately roasted South American and East African Arabicas, combining roasted and subtle floral notes.", 4, brandMonkey);
        this.createCoffee("Linizio Lungo", "ROUND AND SMOOTH", "Mild and well-rounded on the palate, Linizio Lungo is a blend of fine Arabicas enhancing malt and cereal notes.", 4, brandMonkey);
        this.createCoffee("Decaffeinato Intenso", "DENSE AND POWERFUL", "Dark roasted South American Arabicas with a touch of Robusta bring out the subtle cocoa and roasted cereal notes of this full-bodied decaffeinated espresso.", 7, brandMonkey);
        this.createCoffee("Decaffeinato Lungo", "LIGHT AND FULL-FLAVOURED", "The slow roasting of this blend of South American Arabicas with a touch of Robusta gives Decaffeinato Lungo a smooth, creamy body and roasted cereal flavour.", 3, brandMonkey);
        this.createCoffee("Decaffeinato", "FRUITY AND DELICATE", "A blend of South American Arabicas reinforced with just a touch of Robusta is lightly roasted to reveal an aroma of red fruit.", 2, brandPony);
        this.createCoffee("Caramelito", "CARAMEL FLAVOURED", "The sweet flavour of caramel softens the roasted notes of the Livanto Grand Cru. This delicate gourmet marriage evokes the creaminess of soft toffee.", 6, brandMonkey);
        this.createCoffee("Ciocattino", "CHOCOLATE FLAVOURED", "Dark and bitter chocolate notes meet the caramelized roast of the Livanto Grand Cru. A rich combination reminiscent of a square of dark chocolate.", 6, brandMonkey);
        this.createCoffee("Vanilio", "VANILLA FLAVOURED", "A balanced harmony between the rich and the velvety aromas of vanilla and the mellow flavour of the Livanto Grand Cru. A blend distinguished by its full flavour, infinitely smooth and silky on the palate.", 6, brandMonkey);
        tx.commit();
        this.fullTextSession.clear();
    }

    private void createCoffee(String title, String summary, String description, int intensity, CoffeeBrand brand) {
        Coffee coffee = new Coffee();
        coffee.setName(title);
        coffee.setSummary(summary);
        coffee.setDescription(description);
        coffee.setIntensity(intensity);
        coffee.setInternalDescription("Same internal description of coffee and blend that would make things look quite the same.");
        coffee.setBrand(brand);
        this.fullTextSession.persist((Object)coffee);
    }
}

