/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.directoryProvider;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.test.Document;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.util.impl.FileHelper;
import org.junit.Assert;
import org.junit.Test;

public class FSDirectoryTest
extends SearchTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventIntegration() throws Exception {
        Session s = this.getSessionFactory().openSession();
        s.getTransaction().begin();
        s.persist((Object)new Document("Hibernate in Action", "Object/relational mapping with Hibernate", "blah blah blah"));
        s.getTransaction().commit();
        s.close();
        try (FSDirectory dir = FSDirectory.open((File)new File(this.getBaseIndexDir().toString(), "Documents"));){
            int num;
            try (DirectoryReader reader = DirectoryReader.open((Directory)dir);){
                int num2 = reader.numDocs();
                Assert.assertEquals((long)1L, (long)num2);
                Assert.assertEquals((long)1L, (long)reader.docFreq(new Term("Abstract", "hibernate")));
                Assert.assertEquals((long)1L, (long)reader.docFreq(new Term("title", "action")));
                Assert.assertEquals((Object)"1", (Object)this.projectSingleField((IndexReader)reader, "id", new Term("title", "action")));
            }
            s = this.getSessionFactory().openSession();
            s.getTransaction().begin();
            Document entity = (Document)s.get(Document.class, (Serializable)Long.valueOf(1L));
            entity.setSummary("Object/relational mapping with EJB3");
            s.persist((Object)new Document("Seam in Action", "", "blah blah blah blah"));
            s.getTransaction().commit();
            s.close();
            reader = DirectoryReader.open((Directory)dir);
            try {
                num = reader.numDocs();
                Assert.assertEquals((long)2L, (long)num);
                Assert.assertEquals((long)1L, (long)reader.docFreq(new Term("Abstract", "ejb")));
            }
            finally {
                reader.close();
            }
            s = this.getSessionFactory().openSession();
            s.getTransaction().begin();
            s.delete((Object)entity);
            s.getTransaction().commit();
            s.close();
            reader = DirectoryReader.open((Directory)dir);
            try {
                num = reader.numDocs();
                Assert.assertEquals((long)1L, (long)num);
                Assert.assertEquals((long)1L, (long)reader.docFreq(new Term("title", "seam")));
                Assert.assertEquals((Object)"2", (Object)this.projectSingleField((IndexReader)reader, "id", new Term("title", "seam")));
            }
            finally {
                reader.close();
            }
        }
        s = this.getSessionFactory().openSession();
        s.getTransaction().begin();
        s.delete(s.createCriteria(Document.class).uniqueResult());
        s.getTransaction().commit();
        s.close();
    }

    private String projectSingleField(IndexReader reader, String fieldName, Term term) throws IOException {
        String projection = null;
        for (AtomicReaderContext leaf : reader.leaves()) {
            AtomicReader atomicReader = leaf.reader();
            DocsEnum termDocsEnum = atomicReader.termDocsEnum(term);
            while (termDocsEnum.nextDoc() != Integer.MAX_VALUE) {
                int docID = termDocsEnum.docID();
                org.apache.lucene.document.Document document = reader.document(docID);
                String value = document.get(fieldName);
                Assert.assertNull((String)"duplicate matches found! This method assumes a single document will match the Term.", projection);
                projection = value;
            }
        }
        Assert.assertNotNull(projection);
        return projection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBoost() throws Exception {
        Session s = this.getSessionFactory().openSession();
        s.getTransaction().begin();
        s.persist((Object)new Document("Hibernate in Action", "Object and Relational", "blah blah blah"));
        s.persist((Object)new Document("Object and Relational", "Hibernate in Action", "blah blah blah"));
        s.getTransaction().commit();
        s.close();
        FSDirectory dir = FSDirectory.open((File)new File(this.getBaseIndexDir(), "Documents"));
        DirectoryReader indexReader = DirectoryReader.open((Directory)dir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
        try {
            QueryParser qp = new QueryParser(TestConstants.getTargetLuceneVersion(), "id", TestConstants.standardAnalyzer);
            Query query = qp.parse("title:Action OR Abstract:Action");
            TopDocs hits = searcher.search(query, 1000);
            Assert.assertEquals((long)2L, (long)hits.totalHits);
            Assert.assertTrue((hits.scoreDocs[0].score == 2.0f * hits.scoreDocs[1].score ? 1 : 0) != 0);
            org.apache.lucene.document.Document doc = searcher.doc(0);
            Assert.assertEquals((Object)"Hibernate in Action", (Object)doc.get("title"));
        }
        finally {
            indexReader.close();
            dir.close();
        }
        s = this.getSessionFactory().openSession();
        s.getTransaction().begin();
        List list = s.createQuery("from Document").list();
        for (Document document : list) {
            s.delete((Object)document);
        }
        s.getTransaction().commit();
        s.close();
        this.getSessionFactory().close();
    }

    @Test
    public void testSearchOnDeletedIndex() throws Exception {
        Session s = this.getSessionFactory().openSession();
        s.getTransaction().begin();
        s.persist((Object)new Document("Hibernate Search in Action", "", ""));
        s.getTransaction().commit();
        s.close();
        FSDirectory dir = FSDirectory.open((File)new File(this.getBaseIndexDir(), "Documents"));
        DirectoryReader indexReader = DirectoryReader.open((Directory)dir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
        FileHelper.delete((File)this.getBaseIndexDir());
        TermQuery query = new TermQuery(new Term("title", "action"));
        TopDocs hits = searcher.search((Query)query, 1000);
        Assert.assertEquals((long)1L, (long)hits.totalHits);
        org.apache.lucene.document.Document doc = searcher.doc(0);
        Assert.assertEquals((Object)"Hibernate Search in Action", (Object)doc.get("title"));
        indexReader.close();
        dir.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Document.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.directory_provider", "filesystem");
    }
}

