/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.batchindexing;

import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

@Entity
@Indexed
public class Clock {
    private Integer id;
    private String brand;

    public Clock() {
    }

    public Clock(Integer id, String brand) {
        this.id = id;
        this.brand = brand;
    }

    @Field(store=Store.YES)
    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    @Id
    @DocumentId
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.id);
        builder.append(",");
        builder.append(this.brand);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.brand == null ? 0 : this.brand.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Clock other = (Clock)obj;
        return !(this.brand == null ? other.brand != null : !this.brand.equals(other.brand));
    }
}

