/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.path;

import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.junit.Rule;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-2547")
public class DefaultPathsWithNestedIndexedEmbeddedTest {
    @Rule
    public final SearchFactoryHolder sfHolder = new SearchFactoryHolder(new Class[]{A.class, B.class, C.class});
    private final SearchITHelper helper = new SearchITHelper(this.sfHolder);

    @Test
    public void testIndexAndSearch() {
        A a = new A();
        a.id = 0L;
        a.foo = "someValue";
        B b = new B();
        b.a = a;
        b.id = 1L;
        C c = new C();
        c.b = b;
        c.id = 2L;
        this.helper.add(new Object[]{c});
        this.helper.assertThat("b.a.foo", a.foo).from(new Class[]{C.class}).hasResultSize(1);
    }

    @Indexed
    private static class C {
        @DocumentId
        private Long id;
        @IndexedEmbedded
        private B b;

        private C() {
        }
    }

    private static class B {
        @DocumentId
        private Long id;
        @IndexedEmbedded(includePaths={"foo"})
        private A a;

        private B() {
        }
    }

    @Indexed
    private static class A {
        @DocumentId
        private Long id;
        @Field(analyze=Analyze.NO)
        private String foo;

        private A() {
        }
    }
}

