/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.filter.deprecated;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.filter.impl.AndDocIdSet;

public class ExcludeAllFilter
extends Filter
implements Serializable {
    private static final Map<IndexReader, IndexReader> invokedOnReaders = new ConcurrentHashMap<IndexReader, IndexReader>();

    public DocIdSet getDocIdSet(LeafReaderContext context, Bits acceptDocs) throws IOException {
        LeafReader reader = context.reader();
        ExcludeAllFilter.verifyItsAReadOnlySegmentReader((IndexReader)reader);
        IndexReader previousValue = invokedOnReaders.put((IndexReader)reader, (IndexReader)reader);
        if (previousValue != null) {
            throw new IllegalStateException("Called twice");
        }
        return AndDocIdSet.EMPTY_DOCIDSET;
    }

    public static void verifyItsAReadOnlySegmentReader(IndexReader reader) {
        if (!(reader instanceof SegmentReader)) {
            throw new SearchException("test failed: we should receive subreaders");
        }
    }

    public String toString(String field) {
        return "";
    }
}

