/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.filter.fulltextfilterdef;

import java.util.Map;
import org.fest.assertions.Assertions;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FullTextFilterDef;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.impl.FilterDef;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.impl.SearchFactoryState;
import org.hibernate.search.test.filter.RoleFilterFactory;
import org.hibernate.search.test.util.HibernateManualConfiguration;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchIntegratorResource;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class FullTextFilterDefAnnotationTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public SearchFactoryHolder sfHolder = new SearchFactoryHolder(new Class[]{Sample.class});
    @Rule
    public SearchIntegratorResource integratorResource = new SearchIntegratorResource();

    @Test
    public void shouldBePossibleToAnnotatePackage() throws Exception {
        this.assertThatFilterExists("package-filter");
    }

    @Test
    public void shouldBePossibleToAnnotateClass() throws Exception {
        this.assertThatFilterExists("class-filter");
    }

    @Test
    public void shouldContainsOnlyTheDefinedFilters() throws Exception {
        Map filterDefinitions = ((SearchFactoryState)this.sfHolder.getSearchFactory()).getFilterDefinitions();
        Assertions.assertThat(filterDefinitions.keySet()).containsOnly(new Object[]{"package-filter", "class-filter"});
    }

    @Test
    public void shouldNotBePossibleToHaveTwoFilterDefsWithTheSameName() throws Exception {
        this.thrown.expect(SearchException.class);
        HibernateManualConfiguration cfg = new HibernateManualConfiguration();
        cfg.addClass(SampleWithError.class);
        this.integratorResource.create((SearchConfiguration)cfg);
    }

    private void assertThatFilterExists(String filterName) {
        FilterDef filterDefinition = this.sfHolder.getSearchFactory().getFilterDefinition(filterName);
        Assertions.assertThat((Object)filterDefinition).isNotNull();
        Assertions.assertThat((Object)filterDefinition.getImpl()).isEqualTo(RoleFilterFactory.class);
    }

    @Indexed
    @FullTextFilterDef(name="package-filter", impl=RoleFilterFactory.class)
    static class SampleWithError {
        @DocumentId
        final long id = 1L;
        @Field
        final String description = "";

        SampleWithError() {
        }
    }

    @Indexed
    @FullTextFilterDef(name="class-filter", impl=RoleFilterFactory.class)
    static class Sample {
        @DocumentId
        long id;
        @Field
        String description;

        Sample() {
        }
    }
}

