/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.hcore.impl;

import java.util.concurrent.CompletableFuture;
import javax.enterprise.inject.spi.BeanManager;
import org.hibernate.jpa.event.spi.jpa.ExtendedBeanManager;
import org.hibernate.search.hcore.spi.EnvironmentSynchronizer;

class ExtendedBeanManagerSynchronizer
implements EnvironmentSynchronizer,
ExtendedBeanManager.LifecycleListener {
    private final CompletableFuture<Void> environmentInitialized = new CompletableFuture();
    private final CompletableFuture<Void> environmentDestroying = new CompletableFuture();

    ExtendedBeanManagerSynchronizer() {
    }

    @Override
    public void whenEnvironmentReady(Runnable runnable) {
        this.environmentInitialized.thenRun(runnable);
    }

    @Override
    public void whenEnvironmentDestroying(Runnable runnable) {
        this.environmentDestroying.thenRun(runnable);
    }

    public void beanManagerInitialized(BeanManager beanManager) {
        this.environmentInitialized.complete(null);
    }

    public void beforeBeanManagerDestroyed(BeanManager beanManager) {
        this.environmentDestroying.complete(null);
    }
}

