/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.facet;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetSortOrder;
import org.hibernate.search.query.facet.FacetingRequest;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-2535")
public class MultiValuedFacetingTest {
    @Rule
    public final SearchFactoryHolder sfHolder = new SearchFactoryHolder(new Class[]{StringArrayFacetEntity.class, StringCollectionFacetEntity.class, StringMapFacetEntity.class, NumberArrayFacetEntity.class, NumberCollectionFacetEntity.class, NumberMapFacetEntity.class});
    private final SearchITHelper helper = new SearchITHelper(this.sfHolder);

    @Test
    public void stringArray() throws Exception {
        StringArrayFacetEntity entity = new StringArrayFacetEntity((Long)1L, new String[0]);
        this.helper.add(new Object[]{entity});
        entity = new StringArrayFacetEntity((Long)1L, new String[]{"foo"});
        this.helper.add(new Object[]{entity});
        entity = new StringArrayFacetEntity((Long)2L, new String[]{"foo", "bar"});
        this.helper.add(new Object[]{entity});
        HSQuery hsQuery = this.sfHolder.getSearchFactory().createHSQuery((Query)new MatchAllDocsQuery(), new Class[]{StringArrayFacetEntity.class});
        QueryBuilder builder = this.sfHolder.getSearchFactory().buildQueryBuilder().forEntity(StringArrayFacetEntity.class).get();
        FacetingRequest facetReq = builder.facet().name("someFacet").onField("facet").discrete().orderedBy(FacetSortOrder.COUNT_DESC).includeZeroCounts(false).maxFacetCount(10).createFacetingRequest();
        List facets = hsQuery.getFacetManager().enableFaceting(facetReq).getFacets("someFacet");
        Assert.assertEquals((String)"There should be two facets", (long)2L, (long)facets.size());
        this.assertFacet((Facet)facets.get(0), "foo", 2);
        this.assertFacet((Facet)facets.get(1), "bar", 1);
    }

    @Test
    public void stringCollection() throws Exception {
        StringCollectionFacetEntity entity = new StringCollectionFacetEntity((Long)1L, new String[0]);
        this.helper.add(new Object[]{entity});
        entity = new StringCollectionFacetEntity((Long)1L, new String[]{"foo"});
        this.helper.add(new Object[]{entity});
        entity = new StringCollectionFacetEntity((Long)2L, new String[]{"foo", "bar"});
        this.helper.add(new Object[]{entity});
        HSQuery hsQuery = this.sfHolder.getSearchFactory().createHSQuery((Query)new MatchAllDocsQuery(), new Class[]{StringCollectionFacetEntity.class});
        QueryBuilder builder = this.sfHolder.getSearchFactory().buildQueryBuilder().forEntity(StringCollectionFacetEntity.class).get();
        FacetingRequest facetReq = builder.facet().name("someFacet").onField("facet").discrete().orderedBy(FacetSortOrder.COUNT_DESC).includeZeroCounts(false).maxFacetCount(10).createFacetingRequest();
        List facets = hsQuery.getFacetManager().enableFaceting(facetReq).getFacets("someFacet");
        Assert.assertEquals((String)"There should be two facets", (long)2L, (long)facets.size());
        this.assertFacet((Facet)facets.get(0), "foo", 2);
        this.assertFacet((Facet)facets.get(1), "bar", 1);
    }

    @Test
    public void stringMap() throws Exception {
        StringMapFacetEntity entity = new StringMapFacetEntity((Long)1L, new String[0]);
        this.helper.add(new Object[]{entity});
        entity = new StringMapFacetEntity((Long)1L, new String[]{"foo"});
        this.helper.add(new Object[]{entity});
        entity = new StringMapFacetEntity((Long)2L, new String[]{"foo", "bar"});
        this.helper.add(new Object[]{entity});
        HSQuery hsQuery = this.sfHolder.getSearchFactory().createHSQuery((Query)new MatchAllDocsQuery(), new Class[]{StringMapFacetEntity.class});
        QueryBuilder builder = this.sfHolder.getSearchFactory().buildQueryBuilder().forEntity(StringMapFacetEntity.class).get();
        FacetingRequest facetReq = builder.facet().name("someFacet").onField("facet").discrete().orderedBy(FacetSortOrder.COUNT_DESC).includeZeroCounts(false).maxFacetCount(10).createFacetingRequest();
        List facets = hsQuery.getFacetManager().enableFaceting(facetReq).getFacets("someFacet");
        Assert.assertEquals((String)"There should be two facets", (long)2L, (long)facets.size());
        this.assertFacet((Facet)facets.get(0), "foo", 2);
        this.assertFacet((Facet)facets.get(1), "bar", 1);
    }

    @Test
    @Ignore
    public void numberArray() throws Exception {
        NumberArrayFacetEntity entity = new NumberArrayFacetEntity((Long)1L, new int[0]);
        this.helper.add(new Object[]{entity});
        entity = new NumberArrayFacetEntity((Long)1L, new int[]{42});
        this.helper.add(new Object[]{entity});
        entity = new NumberArrayFacetEntity((Long)2L, new int[]{43, 442});
        this.helper.add(new Object[]{entity});
        HSQuery hsQuery = this.sfHolder.getSearchFactory().createHSQuery((Query)new MatchAllDocsQuery(), new Class[]{NumberArrayFacetEntity.class});
        QueryBuilder builder = this.sfHolder.getSearchFactory().buildQueryBuilder().forEntity(NumberArrayFacetEntity.class).get();
        FacetingRequest facetReq = builder.facet().name("someFacet").onField("facet").range().from((Object)Float.valueOf(0.0f)).to((Object)Float.valueOf(100.0f)).excludeLimit().from((Object)Float.valueOf(100.0f)).to((Object)Float.valueOf(500.0f)).excludeLimit().orderedBy(FacetSortOrder.COUNT_DESC).includeZeroCounts(false).maxFacetCount(10).createFacetingRequest();
        List facets = hsQuery.getFacetManager().enableFaceting(facetReq).getFacets("someFacet");
        Assert.assertEquals((String)"There should be two facets", (long)2L, (long)facets.size());
        this.assertFacet((Facet)facets.get(0), "[0.0, 100.0)", 2);
        this.assertFacet((Facet)facets.get(1), "[100.0, 500.0)", 1);
    }

    @Test
    @Ignore
    public void numberCollection() throws Exception {
        NumberCollectionFacetEntity entity = new NumberCollectionFacetEntity((Long)1L, new Float[0]);
        this.helper.add(new Object[]{entity});
        entity = new NumberCollectionFacetEntity((Long)1L, new Float[]{Float.valueOf(42.2f)});
        this.helper.add(new Object[]{entity});
        entity = new NumberCollectionFacetEntity((Long)2L, new Float[]{Float.valueOf(42.3f), Float.valueOf(442.2f)});
        this.helper.add(new Object[]{entity});
        HSQuery hsQuery = this.sfHolder.getSearchFactory().createHSQuery((Query)new MatchAllDocsQuery(), new Class[]{NumberCollectionFacetEntity.class});
        QueryBuilder builder = this.sfHolder.getSearchFactory().buildQueryBuilder().forEntity(NumberCollectionFacetEntity.class).get();
        FacetingRequest facetReq = builder.facet().name("someFacet").onField("facet").range().from((Object)Float.valueOf(0.0f)).to((Object)Float.valueOf(100.0f)).excludeLimit().from((Object)Float.valueOf(100.0f)).to((Object)Float.valueOf(500.0f)).excludeLimit().orderedBy(FacetSortOrder.COUNT_DESC).includeZeroCounts(false).maxFacetCount(10).createFacetingRequest();
        List facets = hsQuery.getFacetManager().enableFaceting(facetReq).getFacets("someFacet");
        Assert.assertEquals((String)"There should be two facets", (long)2L, (long)facets.size());
        this.assertFacet((Facet)facets.get(0), "[0.0, 100.0)", 2);
        this.assertFacet((Facet)facets.get(1), "[100.0, 500.0)", 1);
    }

    @Test
    @Ignore
    public void numberMap() throws Exception {
        NumberMapFacetEntity entity = new NumberMapFacetEntity((Long)1L, new Float[0]);
        this.helper.add(new Object[]{entity});
        entity = new NumberMapFacetEntity((Long)1L, new Float[]{Float.valueOf(42.2f)});
        this.helper.add(new Object[]{entity});
        entity = new NumberMapFacetEntity((Long)2L, new Float[]{Float.valueOf(42.3f), Float.valueOf(442.2f)});
        this.helper.add(new Object[]{entity});
        HSQuery hsQuery = this.sfHolder.getSearchFactory().createHSQuery((Query)new MatchAllDocsQuery(), new Class[]{NumberMapFacetEntity.class});
        QueryBuilder builder = this.sfHolder.getSearchFactory().buildQueryBuilder().forEntity(NumberMapFacetEntity.class).get();
        FacetingRequest facetReq = builder.facet().name("someFacet").onField("facet").range().from((Object)Float.valueOf(0.0f)).to((Object)Float.valueOf(100.0f)).excludeLimit().from((Object)Float.valueOf(100.0f)).to((Object)Float.valueOf(500.0f)).excludeLimit().orderedBy(FacetSortOrder.COUNT_DESC).includeZeroCounts(false).maxFacetCount(10).createFacetingRequest();
        List facets = hsQuery.getFacetManager().enableFaceting(facetReq).getFacets("someFacet");
        Assert.assertEquals((String)"There should be two facets", (long)2L, (long)facets.size());
        this.assertFacet((Facet)facets.get(0), "[0.0, 100.0)", 2);
        this.assertFacet((Facet)facets.get(1), "[100.0, 500.0)", 1);
    }

    private void assertFacet(Facet facet, String expectedValue, int expectedCount) {
        Assert.assertEquals((String)"Wrong facet value", (Object)expectedValue, (Object)facet.getValue());
        Assert.assertEquals((String)"Wrong facet count", (long)expectedCount, (long)facet.getCount());
    }

    @Indexed
    private static class NumberMapFacetEntity {
        @DocumentId
        private Long id;
        @Field(analyze=Analyze.NO, index=Index.NO)
        @org.hibernate.search.annotations.Facet
        @IndexedEmbedded
        private Map<Integer, Float> facet;

        private NumberMapFacetEntity(Long id, Float ... facet) {
            this.id = id;
            this.facet = new TreeMap<Integer, Float>();
            int index = 0;
            for (Float facetValue : facet) {
                this.facet.put(index, facetValue);
                ++index;
            }
        }
    }

    @Indexed
    private static class NumberCollectionFacetEntity {
        @DocumentId
        private Long id;
        @Field(analyze=Analyze.NO)
        @org.hibernate.search.annotations.Facet
        @IndexedEmbedded
        private Collection<Float> facet;

        private NumberCollectionFacetEntity(Long id, Float ... facet) {
            this.id = id;
            this.facet = Arrays.asList(facet);
        }
    }

    @Indexed
    private static class NumberArrayFacetEntity {
        @DocumentId
        private Long id;
        @Field(analyze=Analyze.NO)
        @org.hibernate.search.annotations.Facet
        @IndexedEmbedded
        private int[] facet;

        private NumberArrayFacetEntity(Long id, int ... facet) {
            this.id = id;
            this.facet = facet;
        }
    }

    @Indexed
    private static class StringMapFacetEntity {
        @DocumentId
        private Long id;
        @Field(analyze=Analyze.NO)
        @org.hibernate.search.annotations.Facet
        @IndexedEmbedded
        private Map<Integer, String> facet;

        private StringMapFacetEntity(Long id, String ... facet) {
            this.id = id;
            this.facet = new TreeMap<Integer, String>();
            int index = 0;
            for (String facetValue : facet) {
                this.facet.put(index, facetValue);
                ++index;
            }
        }
    }

    @Indexed
    private static class StringCollectionFacetEntity {
        @DocumentId
        private Long id;
        @Field(analyze=Analyze.NO)
        @org.hibernate.search.annotations.Facet
        @IndexedEmbedded
        private Collection<String> facet;

        private StringCollectionFacetEntity(Long id, String ... facet) {
            this.id = id;
            this.facet = Arrays.asList(facet);
        }
    }

    @Indexed
    private static class StringArrayFacetEntity {
        @DocumentId
        private Long id;
        @Field(analyze=Analyze.NO)
        @org.hibernate.search.annotations.Facet
        @IndexedEmbedded
        private String[] facet;

        private StringArrayFacetEntity(Long id, String ... facet) {
            this.id = id;
            this.facet = facet;
        }
    }
}

