/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration.norms;

import java.util.List;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Norms;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.testsupport.backend.LeakingLocalBackend;
import org.junit.Assert;
import org.junit.Test;

public class StoreNormsTest
extends SearchTestBase {
    @Test
    public void testStoreAndOmitNorms() throws Exception {
        Session session = this.openSession();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        Transaction tx = fullTextSession.beginTransaction();
        NormsTestEntity test = new NormsTestEntity();
        test.setWithNormsImplicit("hello");
        test.setWithNormsExplicit("world");
        test.setWithoutNorms("how are you?");
        fullTextSession.save((Object)test);
        tx.commit();
        List processedQueue = LeakingLocalBackend.getLastProcessedQueue();
        Assert.assertTrue((processedQueue.size() == 1 ? 1 : 0) != 0);
        AddLuceneWork addLuceneWork = (AddLuceneWork)processedQueue.get(0);
        Document doc = addLuceneWork.getDocument();
        IndexableField implicitNormField = doc.getField("withNormsImplicit");
        Assert.assertFalse((String)"norms should be stored for this field", (boolean)implicitNormField.fieldType().omitNorms());
        IndexableField explicitNormField = doc.getField("withNormsExplicit");
        Assert.assertFalse((String)"norms should be stored for this field", (boolean)explicitNormField.fieldType().omitNorms());
        IndexableField withoutNormField = doc.getField("withoutNorms");
        Assert.assertTrue((String)"norms should not be stored for this field", (boolean)withoutNormField.fieldType().omitNorms());
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{NormsTestEntity.class};
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.default.worker.backend", LeakingLocalBackend.class.getName());
    }

    @Entity
    @Indexed(index="test")
    public class NormsTestEntity {
        @Id
        @GeneratedValue
        private int id;
        @Field(store=Store.YES)
        private String withNormsImplicit;
        @Field(norms=Norms.YES, store=Store.YES)
        private String withNormsExplicit;
        @Field(norms=Norms.NO, store=Store.YES)
        private String withoutNorms;

        public String getWithNormsImplicit() {
            return this.withNormsImplicit;
        }

        public void setWithNormsImplicit(String withNormsImplicit) {
            this.withNormsImplicit = withNormsImplicit;
        }

        public String getWithNormsExplicit() {
            return this.withNormsExplicit;
        }

        public void setWithNormsExplicit(String withNormsExplicit) {
            this.withNormsExplicit = withNormsExplicit;
        }

        public String getWithoutNorms() {
            return this.withoutNorms;
        }

        public void setWithoutNorms(String withoutNorms) {
            this.withoutNorms = withoutNorms;
        }
    }
}

