/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query;

import java.util.Iterator;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-2541")
public class ObjectLoadingPublicFieldTest
extends SearchTestBase {
    private Query fieldFooQuery;
    private Query fieldBarQuery;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        try (Session session = this.openSession();){
            Transaction tx = session.beginTransaction();
            A a1 = new A();
            a1.id = 1L;
            a1.field = "foo";
            B b = new B();
            b.id = 2L;
            b.field = "foo";
            C c = new C();
            c.id = 3L;
            c.field = "foo";
            session.persist((Object)a1);
            session.persist((Object)b);
            session.persist((Object)c);
            A a2 = new A();
            a2.id = 4L;
            a2.field = "bar";
            session.persist((Object)a2);
            tx.commit();
        }
        this.fieldFooQuery = new TermQuery(new Term("field", "foo"));
        this.fieldBarQuery = new TermQuery(new Term("field", "bar"));
    }

    @Test
    public void singleClass_singleResult() throws Exception {
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(this.fieldFooQuery, new Class[]{A.class});
        List result = fullTextQuery.list();
        Assert.assertEquals((String)"Should match B only", (long)1L, (long)result.size());
        this.assertPopulated(result);
        fullTextSession.clear();
        fullTextQuery = fullTextSession.createFullTextQuery(this.fieldFooQuery, new Class[]{A.class}).setProjection(new String[]{"__HSearch_This"});
        result = fullTextQuery.list();
        this.assertPopulated(result);
        fullTextSession.clear();
        fullTextQuery = fullTextSession.createFullTextQuery(this.fieldFooQuery, new Class[]{A.class});
        this.assertPopulated(fullTextQuery.iterate());
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void singleClass_multipleResults() throws Exception {
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        MatchAllDocsQuery luceneQuery = new MatchAllDocsQuery();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)luceneQuery, new Class[]{A.class});
        List result = fullTextQuery.list();
        Assert.assertEquals((String)"Should match A only", (long)2L, (long)result.size());
        this.assertPopulated(result);
        fullTextSession.clear();
        fullTextQuery = fullTextSession.createFullTextQuery((Query)luceneQuery, new Class[]{A.class}).setProjection(new String[]{"__HSearch_This"});
        result = fullTextQuery.list();
        this.assertPopulated(result);
        fullTextSession.clear();
        fullTextQuery = fullTextSession.createFullTextQuery((Query)luceneQuery, new Class[]{A.class});
        this.assertPopulated(fullTextQuery.iterate());
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void twoClasses_singleResult() throws Exception {
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(this.fieldBarQuery, new Class[]{A.class, B.class});
        List result = fullTextQuery.list();
        Assert.assertEquals((String)"Should match a single A only", (long)1L, (long)result.size());
        this.assertPopulated(result);
        fullTextSession.clear();
        fullTextQuery = fullTextSession.createFullTextQuery(this.fieldBarQuery, new Class[]{A.class, B.class}).setProjection(new String[]{"__HSearch_This"});
        result = fullTextQuery.list();
        this.assertPopulated(result);
        fullTextSession.clear();
        fullTextQuery = fullTextSession.createFullTextQuery(this.fieldBarQuery, new Class[]{A.class, B.class});
        this.assertPopulated(fullTextQuery.iterate());
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void twoClasses_multipleResults() throws Exception {
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(this.fieldFooQuery, new Class[]{A.class, B.class});
        List result = fullTextQuery.list();
        Assert.assertEquals((String)"Should match A and B only", (long)2L, (long)result.size());
        this.assertPopulated(result);
        fullTextSession.clear();
        fullTextQuery = fullTextSession.createFullTextQuery(this.fieldFooQuery, new Class[]{A.class, B.class}).setProjection(new String[]{"__HSearch_This"});
        result = fullTextQuery.list();
        this.assertPopulated(result);
        fullTextSession.clear();
        fullTextQuery = fullTextSession.createFullTextQuery(this.fieldFooQuery, new Class[]{A.class, B.class});
        this.assertPopulated(fullTextQuery.iterate());
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void threeClasses() throws Exception {
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(this.fieldFooQuery, new Class[]{A.class, B.class, C.class});
        List result = fullTextQuery.list();
        Assert.assertEquals((String)"Should match all types", (long)3L, (long)result.size());
        this.assertPopulated(result);
        fullTextSession.clear();
        fullTextQuery = fullTextSession.createFullTextQuery(this.fieldFooQuery, new Class[]{A.class, B.class, C.class}).setProjection(new String[]{"__HSearch_This"});
        result = fullTextQuery.list();
        this.assertPopulated(result);
        fullTextSession.clear();
        fullTextQuery = fullTextSession.createFullTextQuery(this.fieldFooQuery, new Class[0]);
        this.assertPopulated(fullTextQuery.iterate());
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void implicitAllClasses() throws Exception {
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(this.fieldFooQuery, new Class[0]);
        List result = fullTextQuery.list();
        Assert.assertEquals((String)"Should match all types", (long)3L, (long)result.size());
        this.assertPopulated(result);
        fullTextSession.clear();
        fullTextQuery = fullTextSession.createFullTextQuery(this.fieldFooQuery, new Class[0]).setProjection(new String[]{"__HSearch_This"});
        result = fullTextQuery.list();
        this.assertPopulated(result);
        fullTextSession.clear();
        fullTextQuery = fullTextSession.createFullTextQuery(this.fieldFooQuery, new Class[0]);
        this.assertPopulated(fullTextQuery.iterate());
        tx.commit();
        fullTextSession.close();
    }

    private void assertPopulated(Iterator<?> iterator) {
        while (iterator.hasNext()) {
            Object result = iterator.next();
            this.assertPopulated(result);
        }
    }

    private void assertPopulated(List<?> results) {
        for (Object result : results) {
            this.assertPopulated(result);
        }
    }

    private void assertPopulated(Object result) {
        if (result instanceof Object[]) {
            Object[] tuple = (Object[])result;
            if (tuple.length != 1) {
                throw new AssertionFailure("Unexpected tuple size for result " + result);
            }
            result = tuple[0];
        }
        if (result instanceof A) {
            Assert.assertNotNull((Object)((A)result).id);
        } else if (result instanceof B) {
            Assert.assertNotNull((Object)((B)result).id);
        } else if (result instanceof C) {
            Assert.assertNotNull((Object)((C)result).id);
        } else {
            throw new AssertionFailure("Unexpected type for result " + result);
        }
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{A.class, B.class, C.class};
    }

    @Entity
    @Indexed
    private static class C {
        @Id
        public Long id;
        @Field
        public String field;

        protected C() {
        }
    }

    @Entity
    @Indexed
    private static class B {
        @Id
        public Long id;
        @Field
        public String field;

        protected B() {
        }
    }

    @Entity
    @Table(name="A")
    @Indexed
    private static class A {
        @Id
        public Long id;
        @Field
        public String field;

        protected A() {
        }
    }
}

