/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.polymorphism;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1241")
public class PolymorphicAssociationPropertyAccessTest
extends SearchTestBase {
    private static final String INIT_NAME = "initname";
    private static final String EDIT_NAME = "editname";

    @Test
    public void testPolymorphicAssociation() {
        this.prepareEntities(INIT_NAME);
        this.changeLevel3Name(INIT_NAME, EDIT_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareEntities(String level3Name) {
        try (Session session = this.openSession();){
            Transaction transaction = session.beginTransaction();
            Level1 level1 = new Level1();
            DerivedLevel2 level2 = new DerivedLevel2();
            Level3 level3 = new Level3();
            level1.setLevel2Child(level2);
            level2.setLevel1Parent(level1);
            level2.setLevel3Child(level3);
            level3.setLevel2Parent(level2);
            level3.setName(level3Name);
            session.save((Object)level1);
            session.save((Object)level2);
            session.save((Object)level3);
            transaction.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeLevel3Name(String currentName, String newName) {
        try (FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());){
            Transaction transaction = fullTextSession.beginTransaction();
            TermQuery q = new TermQuery(new Term("name", currentName));
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)q, new Class[0]);
            Assert.assertEquals((long)1L, (long)fullTextQuery.getResultSize());
            Level3 level3 = (Level3)fullTextQuery.list().get(0);
            level3.setName(newName);
            transaction.commit();
        }
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Level1.class, Level2.class, DerivedLevel2.class, Level3.class};
    }

    @Entity(name="Level3")
    @Indexed
    static class Level3 {
        @Id
        @DocumentId
        @GeneratedValue
        private Integer id;
        @Field
        private String name;
        @OneToOne(fetch=FetchType.LAZY)
        @ContainedIn
        private Level2 level2Parent;

        Level3() {
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Level2 getLevel2Parent() {
            return this.level2Parent;
        }

        public void setLevel2Parent(Level2 level2Parent) {
            this.level2Parent = level2Parent;
        }
    }

    @Entity(name="DerivedLevel2")
    @Indexed
    static class DerivedLevel2
    extends Level2 {
        @OneToOne
        @ContainedIn
        private Level1 level1Parent;

        DerivedLevel2() {
        }

        public Level1 getLevel1Parent() {
            return this.level1Parent;
        }

        public void setLevel1Parent(Level1 level1Parent) {
            this.level1Parent = level1Parent;
        }
    }

    @Entity(name="Level2")
    @Indexed
    static class Level2 {
        @Id
        @DocumentId
        @GeneratedValue
        private Integer id;
        @OneToOne(mappedBy="level2Parent")
        @IndexedEmbedded
        private Level3 level3Child;

        Level2() {
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public Level3 getLevel3Child() {
            return this.level3Child;
        }

        public void setLevel3Child(Level3 level3Child) {
            this.level3Child = level3Child;
        }
    }

    @Entity(name="Level1")
    @Indexed
    static class Level1 {
        @Id
        @DocumentId
        @GeneratedValue
        private Integer id;
        @OneToOne(mappedBy="level1Parent")
        @IndexedEmbedded
        private DerivedLevel2 level2Child;

        Level1() {
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public DerivedLevel2 getLevel2Child() {
            return this.level2Child;
        }

        public void setLevel2Child(DerivedLevel2 level2Child) {
            this.level2Child = level2Child;
        }
    }
}

