/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.facet;

import java.util.List;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.query.engine.spi.FacetManager;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetCombine;
import org.hibernate.search.query.facet.FacetingRequest;
import org.hibernate.search.test.query.facet.AbstractFacetTest;
import org.hibernate.search.test.query.facet.Car;
import org.hibernate.search.test.query.facet.Fruit;
import org.hibernate.search.test.query.facet.Ingredient;
import org.hibernate.search.test.query.facet.Recipe;
import org.hibernate.testing.TestForIssue;
import org.junit.Assert;
import org.junit.Test;

public class FacetFilteringTest
extends AbstractFacetTest {
    @Test
    public void testDiscreteFacetDrillDown() throws Exception {
        String facetName = "ccs";
        Query luceneQuery = this.queryBuilder(Car.class).keyword().onField("make").matching((Object)"Honda").createQuery();
        FacetingRequest request = this.queryBuilder(Car.class).facet().name("ccs").onField("cubicCapacity_string_facet_string").discrete().includeZeroCounts(true).createFacetingRequest();
        FullTextQuery query = this.fullTextSession.createFullTextQuery(luceneQuery, new Class[]{Car.class});
        FacetManager facetManager = query.getFacetManager();
        facetManager.enableFaceting(request);
        query.setFirstResult(0).setMaxResults(1);
        Assert.assertEquals((String)"Wrong number of query matches", (long)13L, (long)query.getResultSize());
        List facetList = facetManager.getFacets("ccs");
        this.assertFacetCounts(facetList, new int[]{5, 4, 4, 0});
        facetManager.getFacetGroup("ccs").selectFacets(new Facet[]{(Facet)facetList.get(0)});
        query.list();
        Assert.assertEquals((String)"Wrong number of query matches", (long)5L, (long)query.getResultSize());
        List newFacetList = facetManager.getFacets("ccs");
        this.assertFacetCounts(newFacetList, new int[]{5, 0, 0, 0});
        facetManager.getFacetGroup("ccs").selectFacets(new Facet[]{(Facet)facetList.get(1)});
        query.setMaxResults(1000);
        Assert.assertEquals((String)"Wrong number of query matches", (long)9L, (long)query.list().size());
        newFacetList = facetManager.getFacets("ccs");
        this.assertFacetCounts(newFacetList, new int[]{5, 4, 0, 0});
    }

    @Test
    public void testMultipleFacetDrillDown() throws Exception {
        String ccsFacetName = "ccs";
        FacetingRequest ccsFacetRequest = this.queryBuilder(Car.class).facet().name("ccs").onField("cubicCapacity_string_facet_string").discrete().includeZeroCounts(true).createFacetingRequest();
        String colorFacetName = "color";
        String colorFacetFieldName = "color";
        FacetingRequest colorFacetRequest = this.queryBuilder(Car.class).facet().name("color").onField("color").discrete().includeZeroCounts(true).createFacetingRequest();
        FullTextQuery query = this.createMatchAllQuery(Car.class);
        FacetManager facetManager = query.getFacetManager();
        facetManager.enableFaceting(colorFacetRequest);
        facetManager.enableFaceting(ccsFacetRequest);
        Assert.assertEquals((String)"Wrong number of query matches", (long)50L, (long)query.getResultSize());
        this.assertFacetCounts(facetManager.getFacets("color"), new int[]{12, 12, 12, 12, 2});
        this.assertFacetCounts(facetManager.getFacets("ccs"), new int[]{17, 16, 16, 1});
        Facet colorFacet = (Facet)facetManager.getFacets("color").get(0);
        facetManager.getFacetGroup("color").selectFacets(new Facet[]{colorFacet});
        this.assertFacetCounts(facetManager.getFacets("color"), new int[]{12, 0, 0, 0, 0});
        this.assertFacetCounts(facetManager.getFacets("ccs"), new int[]{4, 4, 4, 0});
        Facet ccsFacet = (Facet)facetManager.getFacets("ccs").get(0);
        facetManager.getFacetGroup("color").selectFacets(new Facet[]{colorFacet});
        facetManager.getFacetGroup("ccs").selectFacets(new Facet[]{ccsFacet});
        this.assertFacetCounts(facetManager.getFacets("color"), new int[]{4, 0, 0, 0, 0});
        this.assertFacetCounts(facetManager.getFacets("ccs"), new int[]{4, 0, 0, 0});
        Assert.assertEquals((String)"Facets should not take count in equality", (Object)colorFacet, facetManager.getFacets("color").get(0));
        Assert.assertTrue((String)"We should be able to find facets amongst the selected ones", (boolean)facetManager.getFacetGroup("color").getSelectedFacets().contains(facetManager.getFacets("color").get(0)));
        facetManager.getFacetGroup("color").clearSelectedFacets();
        facetManager.getFacetGroup("ccs").clearSelectedFacets();
        this.assertFacetCounts(facetManager.getFacets("color"), new int[]{12, 12, 12, 12, 2});
        this.assertFacetCounts(facetManager.getFacets("ccs"), new int[]{17, 16, 16, 1});
    }

    @Test
    public void testRangeFacetDrillDown() {
        String indexFieldName = "price";
        String priceRange = "priceRange";
        FacetingRequest rangeRequest = this.queryBuilder(Fruit.class).facet().name("priceRange").onField("price").range().from((Object)0.0).to((Object)1.0).from((Object)1.01).to((Object)1.5).from((Object)1.51).to((Object)3.0).from((Object)4.0).to((Object)5.0).includeZeroCounts(true).createFacetingRequest();
        FullTextQuery query = this.createMatchAllQuery(Fruit.class);
        FacetManager facetManager = query.getFacetManager();
        facetManager.enableFaceting(rangeRequest);
        Assert.assertEquals((String)"Wrong number of query matches", (long)10L, (long)query.getResultSize());
        List facets = facetManager.getFacets("priceRange");
        this.assertFacetCounts(facets, new int[]{5, 3, 2, 0});
        facetManager.getFacetGroup("priceRange").selectFacets(new Facet[]{(Facet)facets.get(2)});
        Assert.assertEquals((String)"Wrong number of query matches", (long)2L, (long)query.list().size());
        List newFacetList = facetManager.getFacets("priceRange");
        this.assertFacetCounts(newFacetList, new int[]{2, 0, 0, 0});
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-812")
    public void testDiscreteFacetDrillDownWithMultiFacetSelect() throws Exception {
        String indexFieldName = "ingredients.name";
        String facetName = "ingredientsFacetRequest";
        FacetingRequest request = this.queryBuilder(Recipe.class).facet().name("ingredientsFacetRequest").onField("ingredients.name").discrete().createFacetingRequest();
        FullTextQuery query = this.fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[]{Recipe.class});
        FacetManager facetManager = query.getFacetManager();
        facetManager.enableFaceting(request);
        Assert.assertEquals((String)"Wrong number of query matches", (long)3L, (long)query.getResultSize());
        List facetList = facetManager.getFacets("ingredientsFacetRequest");
        this.assertFacetCounts(facetList, new int[]{3, 2, 1, 1, 1});
        this.assertFacetValues(facetList, new Object[]{"Egg", "Potato", "Milk", "Onion", "Salt"});
        facetManager.getFacetGroup("ingredientsFacetRequest").selectFacets(new Facet[]{(Facet)facetList.get(0), (Facet)facetList.get(3)});
        query.list();
        Assert.assertEquals((String)"Wrong number of query matches", (long)3L, (long)query.getResultSize());
        facetList = facetManager.getFacets("ingredientsFacetRequest");
        this.assertFacetCounts(facetList, new int[]{3, 2, 1, 1, 1});
        this.assertFacetValues(facetList, new Object[]{"Egg", "Potato", "Milk", "Onion", "Salt"});
        facetManager.getFacetGroup("ingredientsFacetRequest").selectFacets(FacetCombine.AND, new Facet[]{(Facet)facetList.get(0), (Facet)facetList.get(3)});
        query.list();
        Assert.assertEquals((String)"Wrong number of query matches", (long)1L, (long)query.getResultSize());
        facetList = facetManager.getFacets("ingredientsFacetRequest");
        this.assertFacetCounts(facetList, new int[]{1, 1, 1, 1});
        this.assertFacetValues(facetList, new Object[]{"Egg", "Onion", "Potato", "Salt"});
    }

    @Override
    public void loadTestData(Session session) {
        Transaction tx = session.beginTransaction();
        for (int i = 0; i < fruits.length; ++i) {
            Fruit fruit = new Fruit(fruits[i], fruitPrices[i]);
            session.save((Object)fruit);
        }
        for (String make : makes) {
            for (String color : colors) {
                for (int cc : ccs) {
                    Car car = new Car(make, color, cc);
                    session.save((Object)car);
                }
            }
        }
        Car car = new Car("Honda", "yellow", 2407);
        session.save((Object)car);
        car = new Car("Ford", "yellow", 2500);
        session.save((Object)car);
        Ingredient potato = new Ingredient("Potato");
        session.save((Object)potato);
        Ingredient milk = new Ingredient("Milk");
        session.save((Object)milk);
        Ingredient salt = new Ingredient("Salt");
        session.save((Object)salt);
        Ingredient egg = new Ingredient("Egg");
        session.save((Object)egg);
        Ingredient onion = new Ingredient("Onion");
        session.save((Object)onion);
        Recipe potatoMash = new Recipe("Potato Mash");
        potatoMash.addIngredients(potato, milk, egg);
        session.save((Object)potatoMash);
        Recipe tortilla = new Recipe("Tortilla");
        tortilla.addIngredients(potato, egg, onion, salt);
        session.save((Object)tortilla);
        Recipe poachedEgg = new Recipe("Poached Egg");
        poachedEgg.addIngredients(egg);
        session.save((Object)poachedEgg);
        tx.commit();
        session.clear();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Car.class, Fruit.class, Recipe.class, Ingredient.class};
    }
}

