/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;

@Entity
@Indexed
@Table(name="ABT_Entity")
public class ArrayBridgeNullEmbeddedTestEntity {
    static final String NULL_TOKEN = "NULL_MARKER";
    static final String NULL_NUMERIC_TOKEN = "-555";
    static final String NULL_EMBEDDED = "EMBEDDED_NULL";
    static final String NULL_EMBEDDED_NUMERIC = "-666";
    private Long id;
    private String name;
    private Language[] nullIndexed = new Language[0];
    private Integer[] numericNullIndexed = new Integer[0];

    @Id
    @GeneratedValue
    @Column(name="array_id")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="name")
    @Field(store=Store.YES)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Field(indexNullAs="NULL_MARKER", analyze=Analyze.NO)
    @ElementCollection
    @IndexedEmbedded(indexNullAs="EMBEDDED_NULL")
    @OrderColumn
    @CollectionTable(name="NullIndexed", joinColumns={@JoinColumn(name="array_id")})
    @Column(name="nullIndexed")
    public Language[] getNullIndexed() {
        return this.nullIndexed;
    }

    public void setNullIndexed(Language[] nullIndexed) {
        this.nullIndexed = nullIndexed;
    }

    @Field(store=Store.YES, indexNullAs="-555", analyze=Analyze.NO)
    @ElementCollection
    @IndexedEmbedded(prefix="embeddedNum.", indexNullAs="-666")
    @OrderColumn
    @CollectionTable(name="NumericNullIndexed", joinColumns={@JoinColumn(name="array_id")})
    @Column(name="numericNullIndexed")
    public Integer[] getNumericNullIndexed() {
        return this.numericNullIndexed;
    }

    public void setNumericNullIndexed(Integer[] phoneNumbers) {
        this.numericNullIndexed = phoneNumbers;
    }

    public String toString() {
        return ArrayBridgeNullEmbeddedTestEntity.class.getSimpleName() + "[id=" + this.id + ", name=" + this.name + "]";
    }

    public static enum Language {
        ITALIAN,
        ENGLISH,
        PIRATE,
        KLINGON;

    }
}

