/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge.provider;

import java.util.List;
import org.apache.lucene.search.Query;
import org.assertj.core.api.Assertions;
import org.hibernate.Session;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.bridge.provider.Movie;
import org.hibernate.search.test.bridge.provider.Theater;
import org.junit.Test;

public class BridgeProviderTest
extends SearchTestBase {
    @Test
    public void testCustomBridgeProvider() {
        Session s = this.openSession();
        s.getTransaction().begin();
        Movie laConfidential = new Movie("LA Confidential");
        Theater legendary = new Theater("Legendary theater", laConfidential);
        s.persist((Object)laConfidential);
        s.persist((Object)legendary);
        s.getTransaction().commit();
        s.clear();
        s.getTransaction().begin();
        FullTextSession fts = Search.getFullTextSession((Session)s);
        QueryBuilder qb = fts.getSearchFactory().buildQueryBuilder().forEntity(Theater.class).get();
        Query query = qb.keyword().onField("movie").matching((Object)laConfidential).createQuery();
        Assertions.assertThat((List)fts.createFullTextQuery(query, new Class[]{Theater.class}).list()).as("The SearchFactory should build and find a bridge for Movie in Theater and  properly use it for indexing", new Object[0]).hasSize(1);
        s.getTransaction().commit();
        s.clear();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Movie.class, Theater.class};
    }
}

