/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.FixedBitSet;
import org.hibernate.search.filter.impl.AndDocIdSet;
import org.junit.Assert;
import org.junit.Test;

public class AndDocIdSetsTest {
    static final List<Integer> testDataFrom0to9 = AndDocIdSetsTest.toImmutableList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
    static final List<Integer> testDataFrom1to10 = AndDocIdSetsTest.toImmutableList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10);
    static final List<Integer> testDataFrom1to9 = AndDocIdSetsTest.toImmutableList(1, 2, 3, 4, 5, 6, 7, 8, 9);

    private static List<Integer> toImmutableList(int ... is) {
        ArrayList<Integer> l = new ArrayList<Integer>(is.length);
        for (int i1 : is) {
            l.add(i1);
        }
        return Collections.unmodifiableList(l);
    }

    List<Integer> andLists(List<Integer> ... lists) {
        if (lists.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Integer> result = new ArrayList<Integer>(lists[0]);
        for (int i = 1; i < lists.length; ++i) {
            result.retainAll(lists[i]);
        }
        return result;
    }

    @Test
    public void testAndingArrays() {
        List<Integer> andLists = this.andLists(testDataFrom0to9, testDataFrom1to10);
        Assert.assertTrue((boolean)andLists.containsAll(testDataFrom1to9));
        Assert.assertFalse((boolean)andLists.contains(0));
        Assert.assertFalse((boolean)andLists.contains(10));
        Assert.assertTrue((boolean)andLists.equals(testDataFrom1to9));
        DocIdSet docIdSet0_9 = this.arrayToDocIdSet(testDataFrom0to9);
        DocIdSet docIdSet1_10 = this.arrayToDocIdSet(testDataFrom1to10);
        DocIdSet docIdSet1_9 = this.arrayToDocIdSet(testDataFrom1to9);
        Assert.assertTrue((boolean)AndDocIdSetsTest.docIdSetsEqual(docIdSet0_9, docIdSet0_9));
        Assert.assertTrue((boolean)AndDocIdSetsTest.docIdSetsEqual(docIdSet1_10, docIdSet1_10));
        Assert.assertFalse((boolean)AndDocIdSetsTest.docIdSetsEqual(docIdSet1_10, docIdSet1_9));
        Assert.assertFalse((boolean)AndDocIdSetsTest.docIdSetsEqual(docIdSet0_9, docIdSet1_9));
    }

    @Test
    public void testIteratorMatchesTestArray() throws IOException {
        DocIdSet docIdSet0_9 = this.arrayToDocIdSet(testDataFrom0to9);
        DocIdSetIterator docIdSetIterator = docIdSet0_9.iterator();
        Assert.assertTrue((docIdSetIterator.nextDoc() != Integer.MAX_VALUE ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)docIdSetIterator.docID());
        Assert.assertEquals((long)9L, (long)docIdSetIterator.advance(9));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)docIdSetIterator.advance(10));
    }

    @Test
    public void testAndDocIdSets() {
        ArrayList<DocIdSet> filters = new ArrayList<DocIdSet>(2);
        filters.add(this.arrayToDocIdSet(testDataFrom0to9));
        filters.add(this.arrayToDocIdSet(testDataFrom1to10));
        DocIdSet expected = this.arrayToDocIdSet(testDataFrom1to9);
        AndDocIdSet testedSet = new AndDocIdSet(filters, 10);
        Assert.assertTrue((boolean)AndDocIdSetsTest.docIdSetsEqual(expected, (DocIdSet)testedSet));
    }

    @Test
    public void testOnRandomBigArrays() {
        this.onRandomBigArraysTest(13L);
        this.onRandomBigArraysTest(9L);
        this.onRandomBigArraysTest(71L);
    }

    public void onRandomBigArraysTest(long randomSeed) {
        List<FixedBitSet> filtersData = AndDocIdSetsTest.makeRandomBitSetList(randomSeed, 4, 1000000, 1500000);
        FixedBitSet expectedBitset = AndDocIdSetsTest.applyANDOnBitSets(filtersData);
        List<DocIdSet> filters = AndDocIdSetsTest.toDocIdSetList(filtersData);
        BitDocIdSet expectedDocIdSet = new BitDocIdSet((BitSet)expectedBitset);
        AndDocIdSet testedSet = new AndDocIdSet(filters, 1500000);
        Assert.assertTrue((boolean)AndDocIdSetsTest.docIdSetsEqual((DocIdSet)expectedDocIdSet, (DocIdSet)testedSet));
    }

    private static List<DocIdSet> toDocIdSetList(List<FixedBitSet> filtersData) {
        ArrayList<DocIdSet> docIdSets = new ArrayList<DocIdSet>(filtersData.size());
        for (BitSet bitSet : filtersData) {
            docIdSets.add((DocIdSet)new BitDocIdSet(bitSet));
        }
        return docIdSets;
    }

    public static void main(String[] args) throws IOException {
        AndDocIdSetsTest.compareAndingPerformance(8, 1000000, 1500000);
        AndDocIdSetsTest.compareAndingPerformance(4, 1000000, 1500000);
        AndDocIdSetsTest.compareAndingPerformance(2, 1000000, 1500000);
        AndDocIdSetsTest.compareAndingPerformance(2, 100000000, 150000000);
        AndDocIdSetsTest.compareAndingPerformance(4, 100000000, 150000000);
        AndDocIdSetsTest.compareAndingPerformance(8, 100000000, 150000000);
    }

    private static void compareAndingPerformance(int listSize, int minBitsSize, int maxBitsSize) throws IOException {
        List<FixedBitSet> filtersData = AndDocIdSetsTest.makeRandomBitSetList(13L, listSize, minBitsSize, maxBitsSize);
        BitDocIdSet andedByBitsResult = null;
        AndDocIdSet andedByIterationResult = null;
        long startTime = System.nanoTime();
        for (int i = 0; i < 1000; ++i) {
            FixedBitSet expectedBitset = AndDocIdSetsTest.applyANDOnBitSets(filtersData);
            andedByBitsResult = new BitDocIdSet((BitSet)expectedBitset);
            AndDocIdSetsTest.iterateOnResults((DocIdSet)andedByBitsResult);
        }
        long totalTimeMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
        System.out.println("Time to \"AND " + listSize + " BitSets and iterate on results\" 1000 times: " + totalTimeMs + "ms. (" + minBitsSize + " minimum BitSet size)");
        List<DocIdSet> docIdSetList = AndDocIdSetsTest.toDocIdSetList(filtersData);
        long startTime2 = System.nanoTime();
        for (int i = 0; i < 1000; ++i) {
            andedByIterationResult = new AndDocIdSet(docIdSetList, maxBitsSize);
            AndDocIdSetsTest.iterateOnResults((DocIdSet)andedByIterationResult);
        }
        long totalTimeMs2 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime2);
        System.out.println("Time to \"use AndDocIdSet iterator on " + listSize + " Filters and iterate on results\" 1000 times: " + totalTimeMs2 + "ms. (" + minBitsSize + " minimum BitSet size)");
        System.out.println(" Results are same: " + AndDocIdSetsTest.docIdSetsEqual((DocIdSet)andedByBitsResult, (DocIdSet)andedByIterationResult));
    }

    private static void iterateOnResults(DocIdSet docIdBitSet) throws IOException {
        int currentDoc;
        DocIdSetIterator iterator = docIdBitSet.iterator();
        while ((currentDoc = iterator.nextDoc()) != Integer.MAX_VALUE) {
        }
    }

    private static FixedBitSet applyANDOnBitSets(List<FixedBitSet> filtersData) {
        FixedBitSet first = filtersData.get(0);
        FixedBitSet toreturn = first.clone();
        for (FixedBitSet bits : filtersData) {
            toreturn.and(bits);
        }
        return toreturn;
    }

    private static List<FixedBitSet> makeRandomBitSetList(long randomSeed, int listSize, int minBitsSize, int maxBitsSize) {
        Random r = new Random(randomSeed);
        ArrayList<FixedBitSet> resultList = new ArrayList<FixedBitSet>(listSize);
        for (int i = 0; i < listSize; ++i) {
            int arraySize = minBitsSize + r.nextInt(maxBitsSize - minBitsSize);
            resultList.add(AndDocIdSetsTest.makeRandomBitSet(r, arraySize));
        }
        return resultList;
    }

    private static FixedBitSet makeRandomBitSet(Random randomSource, int maxSize) {
        FixedBitSet bitSet = new FixedBitSet(maxSize);
        for (int datai = 0; datai < maxSize; ++datai) {
            if (!randomSource.nextBoolean()) continue;
            bitSet.set(datai);
        }
        return bitSet;
    }

    public DocIdSet arrayToDocIdSet(List<Integer> docIdList) {
        int max = -1;
        for (int i : docIdList) {
            max = Math.max(max, i);
        }
        FixedBitSet bitset = new FixedBitSet(max + 1);
        for (int i : docIdList) {
            bitset.set(i);
        }
        return new BitDocIdSet((BitSet)bitset);
    }

    public DocIdSet integersToDocIdSet(int ... integers) {
        int max = -1;
        for (int i : integers) {
            max = Math.max(max, i);
        }
        FixedBitSet bitset = new FixedBitSet(max + 1);
        for (int i : integers) {
            bitset.set(i);
        }
        return new BitDocIdSet((BitSet)bitset);
    }

    public static boolean docIdSetsEqual(DocIdSet expected, DocIdSet actual) {
        try {
            int nextA;
            DocIdSetIterator iterA = expected.iterator();
            DocIdSetIterator iterB = actual.iterator();
            do {
                int nextB;
                if ((nextA = iterA.nextDoc()) != (nextB = iterB.nextDoc())) {
                    return false;
                }
                Assert.assertEquals((long)iterA.docID(), (long)iterB.docID());
            } while (nextA != Integer.MAX_VALUE);
        }
        catch (IOException ioe) {
            Assert.fail((String)"these DocIdSetIterator instances should not throw any exceptions");
        }
        return true;
    }

    @Test
    public void testWithDocIdBitSet() {
        DocIdSet idSet1 = this.integersToDocIdSet(0, 5, 6, 10);
        DocIdSet idSet2 = this.integersToDocIdSet(6);
        AndDocIdSet actual = this.createAndDocIdSet(idSet1, idSet2);
        DocIdSet expected = this.integersToDocIdSet(6);
        Assert.assertTrue((boolean)AndDocIdSetsTest.docIdSetsEqual(expected, (DocIdSet)actual));
    }

    @Test
    public void testWithFixedBitSet() throws IOException {
        FixedBitSet idSet1 = new FixedBitSet(12);
        idSet1.or(this.integersToDocIdSet(0, 5, 6, 10).iterator());
        FixedBitSet idSet2 = new FixedBitSet(7);
        idSet2.set(6);
        AndDocIdSet actual = this.createAndDocIdSet(new DocIdSet[]{new BitDocIdSet((BitSet)idSet1), new BitDocIdSet((BitSet)idSet2)});
        DocIdSet expected = this.integersToDocIdSet(6);
        Assert.assertTrue((boolean)AndDocIdSetsTest.docIdSetsEqual(expected, (DocIdSet)actual));
    }

    @Test
    public void testEmptyDocIdSet() throws Exception {
        BitDocIdSet idSet1 = new BitDocIdSet((BitSet)new FixedBitSet(0));
        DocIdSet idSet2 = this.integersToDocIdSet(0, 5, 6, 10);
        AndDocIdSet actual = this.createAndDocIdSet(new DocIdSet[]{idSet1, idSet2});
        DocIdSet expected = AndDocIdSet.EMPTY_DOCIDSET;
        Assert.assertTrue((boolean)AndDocIdSetsTest.docIdSetsEqual(expected, (DocIdSet)actual));
    }

    private AndDocIdSet createAndDocIdSet(DocIdSet ... docIdSets) {
        ArrayList<DocIdSet> list = new ArrayList<DocIdSet>();
        list.addAll(Arrays.asList(docIdSets));
        return new AndDocIdSet(list, 100);
    }
}

