/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.analyzer;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.analyzer.Discriminator;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.AnalyzerDefs;
import org.hibernate.search.annotations.AnalyzerDiscriminator;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.analyzer.AnalyzerForTests1;
import org.hibernate.search.test.analyzer.TestTokenizer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.junit.Assert;
import org.junit.Test;

public class CustomAnalyzerInClassBridgeTest
extends SearchTestBase {
    public static final Log log = LoggerFactory.make();

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Foo.class, Bar.class};
    }

    @Test
    public void testCustomAnalyzersAppliedForFieldsAddedInClassBridge() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        fullTextSession.persist((Object)new Foo());
        tx.commit();
        fullTextSession.clear();
        String[] searchTokens = new String[]{"dog", "cat", "mouse"};
        for (int i = 0; i < searchTokens.length; ++i) {
            TermQuery termQuery = new TermQuery(new Term(FooBridge.fieldNames[i], searchTokens[i]));
            FullTextQuery query = fullTextSession.createFullTextQuery((Query)termQuery, new Class[0]);
            Assert.assertEquals((String)"custom analyzer should have inserted search token", (long)1L, (long)query.getResultSize());
        }
        fullTextSession.close();
    }

    @Test
    public void testClassBridgeWithSingleField() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        fullTextSession.persist((Object)new Bar());
        tx.commit();
        fullTextSession.clear();
        TermQuery termQuery = new TermQuery(new Term("classField", "dog"));
        FullTextQuery query = fullTextSession.createFullTextQuery((Query)termQuery, new Class[0]);
        Assert.assertEquals((String)"custom analyzer should have inserted search token", (long)1L, (long)query.getResultSize());
        fullTextSession.close();
    }

    public static class BarBridge
    implements FieldBridge {
        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            Field field = new Field(name, "This text will be replaced by the test analyzers", luceneOptions.getStore(), luceneOptions.getIndex(), luceneOptions.getTermVector());
            field.setBoost(luceneOptions.getBoost());
            document.add((IndexableField)field);
        }
    }

    @Entity
    @Table(name="JUSTBAR")
    @Indexed
    @ClassBridge(name="classField", impl=BarBridge.class, analyzer=@Analyzer(impl=AnalyzerForTests1.class))
    public static class Bar {
        @Id
        @GeneratedValue
        private Integer id;
    }

    public static class FooBridge
    implements Discriminator,
    FieldBridge {
        public static final String[] fieldNames = new String[]{"field1", "field2", "field3"};
        public static final String[] analyzerNames = new String[]{"analyzer1", "analyzer2", "analyzer3"};

        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            for (String fieldName : fieldNames) {
                Field field = new Field(fieldName, "This text will be replaced by the test analyzers", luceneOptions.getStore(), luceneOptions.getIndex(), luceneOptions.getTermVector());
                field.setBoost(luceneOptions.getBoost());
                document.add((IndexableField)field);
            }
        }

        public String getAnalyzerDefinitionName(Object value, Object entity, String field) {
            for (int i = 0; i < fieldNames.length; ++i) {
                if (!fieldNames[i].equals(field)) continue;
                return analyzerNames[i];
            }
            return null;
        }
    }

    @Entity
    @Table(name="JUSTFOO")
    @Indexed
    @ClassBridge(impl=FooBridge.class)
    @AnalyzerDiscriminator(impl=FooBridge.class)
    @AnalyzerDefs(value={@AnalyzerDef(name="analyzer1", tokenizer=@TokenizerDef(factory=TestTokenizer.TestTokenizer1.class)), @AnalyzerDef(name="analyzer2", tokenizer=@TokenizerDef(factory=TestTokenizer.TestTokenizer2.class)), @AnalyzerDef(name="analyzer3", tokenizer=@TokenizerDef(factory=TestTokenizer.TestTokenizer3.class))})
    public static class Foo {
        @Id
        @GeneratedValue
        private Integer id;
    }
}

