/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.compression;

import java.util.zip.DataFormatException;
import org.apache.lucene.document.CompressionTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.exception.SearchException;

public class HTMLBoldFieldBridge
implements FieldBridge,
TwoWayFieldBridge {
    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        String fieldValue = this.objectToString(value);
        luceneOptions.addFieldToDocument(name, fieldValue, document);
    }

    public Object get(String name, Document document) {
        String stringValue;
        IndexableField field = document.getField(name);
        if (field.binaryValue() != null) {
            try {
                stringValue = CompressionTools.decompressString((BytesRef)field.binaryValue());
            }
            catch (DataFormatException e) {
                throw new SearchException("Field " + name + " looks like binary but couldn't be decompressed");
            }
        } else {
            stringValue = field.stringValue();
        }
        return stringValue.substring(3, stringValue.length() - 4);
    }

    public String objectToString(Object value) {
        String originalValue = value.toString();
        return "<b>" + originalValue + "</b>";
    }
}

