/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.path.id;

import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.embedded.path.id.DocumentEntity;
import org.hibernate.search.test.embedded.path.id.EntityA;
import org.hibernate.search.test.embedded.path.id.EntityB;
import org.hibernate.search.test.embedded.path.id.EntityC;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IdIncludedInPathCaseEmbeddedTest
extends SearchTestBase {
    private Session s = null;
    private EntityA entityA = null;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        EntityC indexedC = new EntityC("indexedId", "indexed");
        EntityC skippedC = new EntityC("skippedId", "indexed");
        DocumentEntity documentEntity = new DocumentEntity("indexedDocumentId");
        documentEntity.c = indexedC;
        indexedC.document = documentEntity;
        EntityB indexedB = new EntityB(indexedC, skippedC);
        this.entityA = new EntityA(indexedB);
        this.s = this.openSession();
        this.persistEntity(this.s, documentEntity, indexedC, skippedC, indexedB, this.entityA);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.s.clear();
        this.deleteAll(this.s, this.getAnnotatedClasses());
        this.s.close();
        super.tearDown();
    }

    @Test
    public void testIdAttributeIndexedIfInPath() throws Exception {
        List<EntityA> result = this.search(this.s, "b.indexed.id", "indexedId");
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)this.entityA.id, (long)result.get((int)0).id);
    }

    @Test
    public void testDocumentIdIsIndexedIfInPath() throws Exception {
        List<EntityA> result = this.search(this.s, "b.indexed.document.documentId", "indexedDocumentId");
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)this.entityA.id, (long)result.get((int)0).id);
    }

    @Test
    public void testEmbeddedNotIndexedIfNotInPath() throws Exception {
        try {
            this.search(this.s, "b.skipped.skippedId", "skippedId");
            Assert.fail((String)"Should not index embedded property if not in path and not in depth limit");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected error message: " + e.getMessage()), (boolean)e.getMessage().startsWith("Unable to find field"));
        }
    }

    private List<EntityA> search(Session s, String field, String value) {
        FullTextSession session = Search.getFullTextSession((Session)s);
        QueryBuilder queryBuilder = session.getSearchFactory().buildQueryBuilder().forEntity(EntityA.class).get();
        Query query = queryBuilder.keyword().onField(field).matching((Object)value).createQuery();
        List result = session.createFullTextQuery(query, new Class[0]).list();
        return result;
    }

    private void deleteAll(Session s, Class<?> ... classes) {
        Transaction tx = s.beginTransaction();
        for (Class<?> each : classes) {
            List list = s.createCriteria(each).list();
            for (Object object : list) {
                s.delete(object);
            }
        }
        tx.commit();
    }

    private void persistEntity(Session s, Object ... entities) {
        Transaction tx = s.beginTransaction();
        for (Object entity : entities) {
            s.persist(entity);
        }
        tx.commit();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{EntityA.class, EntityB.class, EntityC.class, DocumentEntity.class};
    }
}

