/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.batchindexing;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.fest.assertions.Assertions;
import org.fest.util.Collections;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.batchindexing.Clock;
import org.hibernate.testing.RequiresDialect;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@RequiresDialect(comment="The connection provider for this test requires H2", strictMatching=true, value={H2Dialect.class})
public class DatabaseMultitenancyTest
extends SearchTestBase {
    public static final Dialect DIALECT = new H2Dialect();
    private static final String METAMEC_TID = "metamec";
    private static final String GEOCHRON_TID = "geochron";
    private static Clock[] METAMEC_MODELS = new Clock[]{new Clock(1, "Metamec - Model A850"), new Clock(2, "Metamec - Model 4562"), new Clock(5, "Metamec - Model 792")};
    private static Clock[] GEOCHRON_MODELS = new Clock[]{new Clock(1, "Geochron - Model The Original Kilburg"), new Clock(2, "Geochron - Model The Boardroom"), new Clock(9, "Geochron - Model Designer Series")};

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Session sessionMetamec = this.openSessionWithTenantId(METAMEC_TID);
        this.persist(sessionMetamec, METAMEC_MODELS);
        sessionMetamec.close();
        Session sessionGeochron = this.openSessionWithTenantId(GEOCHRON_TID);
        this.persist(sessionGeochron, GEOCHRON_MODELS);
        sessionGeochron.close();
    }

    @Test
    public void shouldOnlyFindMetamecModels() throws Exception {
        List<Clock> list = this.searchAll(METAMEC_TID);
        Assertions.assertThat(list).isNotEmpty();
        Assertions.assertThat(list).containsOnly((Object[])METAMEC_MODELS);
    }

    @Test
    public void shouldOnlyFindGeochronModels() throws Exception {
        List<Clock> list = this.searchAll(GEOCHRON_TID);
        Assertions.assertThat(list).isNotEmpty();
        Assertions.assertThat(list).containsOnly((Object[])GEOCHRON_MODELS);
    }

    @Test
    public void shouldMatchOnlyElementsFromOneTenant() throws Exception {
        List<Clock> list = this.searchModel("model", GEOCHRON_TID);
        Assertions.assertThat(list).isNotEmpty();
        Assertions.assertThat(list).containsOnly((Object[])GEOCHRON_MODELS);
    }

    @Test
    public void shouldBeAbleToPurgeTheIndex() throws Exception {
        this.purgeAll(Clock.class, GEOCHRON_TID);
        List<Clock> listg = this.searchAll(GEOCHRON_TID);
        Assertions.assertThat(listg).isEmpty();
        List<Clock> listm = this.searchAll(METAMEC_TID);
        Assertions.assertThat(listm).isNotEmpty();
        Assertions.assertThat(listm).containsOnly((Object[])METAMEC_MODELS);
    }

    @Test
    public void shouldBeAbleToRebuildTheIndexForTheTenantId() throws Exception {
        this.purgeAll(Clock.class, GEOCHRON_TID);
        this.purgeAll(Clock.class, METAMEC_TID);
        this.rebuildIndexWithMassIndexer(Clock.class, GEOCHRON_TID);
        List<Clock> listg = this.searchAll(GEOCHRON_TID);
        Assertions.assertThat(listg).isNotEmpty();
        Assertions.assertThat(listg).containsOnly((Object[])GEOCHRON_MODELS);
        List<Clock> listm = this.searchAll(METAMEC_TID);
        Assertions.assertThat(listm).isEmpty();
    }

    @Test
    public void shouldOnlyPurgeTheEntitiesOfTheSelectedTenant() throws Exception {
        this.purgeAll(Clock.class, GEOCHRON_TID);
        List<Clock> list = this.searchAll(METAMEC_TID);
        Assertions.assertThat(list).containsOnly((Object[])METAMEC_MODELS);
    }

    @Test
    public void shouldPurgeOnStartOnlyTheSelectedTenant() throws Exception {
        this.rebuildIndexWithMassIndexer(Clock.class, GEOCHRON_TID);
        List<Clock> metamecList = this.searchAll(METAMEC_TID);
        Assertions.assertThat(metamecList).containsOnly((Object[])METAMEC_MODELS);
        List<Clock> geochronList = this.searchAll(GEOCHRON_TID);
        Assertions.assertThat(geochronList).containsOnly((Object[])GEOCHRON_MODELS);
    }

    @Test
    public void shouldOnlyReturnResultsOfTheSpecificTenant() throws Exception {
        this.purgeAll(Clock.class, GEOCHRON_TID);
        this.purgeAll(Clock.class, METAMEC_TID);
        this.rebuildIndexWithMassIndexer(Clock.class, GEOCHRON_TID);
        List<Clock> list = this.searchAll(METAMEC_TID);
        Assertions.assertThat(list).isEmpty();
    }

    @Test
    public void shouldSearchOtherTenantsDocuments() throws Exception {
        this.purgeAll(Clock.class, GEOCHRON_TID);
        this.purgeAll(Clock.class, METAMEC_TID);
        this.rebuildIndexWithMassIndexer(Clock.class, GEOCHRON_TID);
        List<Clock> list = this.searchModel(GEOCHRON_TID, METAMEC_TID);
        Assertions.assertThat(list).isEmpty();
    }

    private List<Clock> searchModel(String searchString, String tenantId) {
        FullTextSession session = Search.getFullTextSession((Session)this.openSessionWithTenantId(tenantId));
        QueryBuilder queryBuilder = session.getSearchFactory().buildQueryBuilder().forEntity(Clock.class).get();
        Query luceneQuery = queryBuilder.keyword().wildcard().onField("brand").matching((Object)searchString).createQuery();
        Transaction transaction = session.beginTransaction();
        List list = session.createFullTextQuery(luceneQuery, new Class[0]).list();
        transaction.commit();
        session.clear();
        session.close();
        return list;
    }

    private List<Clock> searchAll(String tenantId) {
        FullTextSession session = Search.getFullTextSession((Session)this.openSessionWithTenantId(tenantId));
        QueryBuilder queryBuilder = session.getSearchFactory().buildQueryBuilder().forEntity(Clock.class).get();
        Query luceneQuery = queryBuilder.all().createQuery();
        Transaction transaction = session.beginTransaction();
        List list = session.createFullTextQuery(luceneQuery, new Class[0]).list();
        transaction.commit();
        session.clear();
        session.close();
        return list;
    }

    private void rebuildIndexWithMassIndexer(Class<?> entityType, String tenantId) throws Exception {
        FullTextSession session = Search.getFullTextSession((Session)this.openSessionWithTenantId(tenantId));
        session.createIndexer(new Class[]{entityType}).purgeAllOnStart(true).startAndWait();
        IndexReader indexReader = session.getSearchFactory().getIndexReaderAccessor().open(new Class[]{entityType});
        long tenantIdTermFreq = indexReader.docFreq(new Term("__HSearch_TenantId", tenantId));
        session.close();
        Assertions.assertThat((long)tenantIdTermFreq).isGreaterThan(0L);
    }

    private void purgeAll(Class<?> entityType, String tenantId) throws IOException {
        FullTextSession session = Search.getFullTextSession((Session)this.openSessionWithTenantId(tenantId));
        session.purgeAll(entityType);
        session.flushToIndexes();
        IndexReader indexReader = session.getSearchFactory().getIndexReaderAccessor().open(new Class[]{entityType});
        long tenantIdTermFreq = indexReader.docFreq(new Term("__HSearch_TenantId", tenantId));
        session.close();
        Assertions.assertThat((long)tenantIdTermFreq).isEqualTo(0L);
    }

    private Session openSessionWithTenantId(String tenantId) {
        return this.getSessionFactory().withOptions().tenantIdentifier(tenantId).openSession();
    }

    private void persist(Session session, Clock ... clocks) {
        session.beginTransaction();
        for (Clock clock : clocks) {
            session.persist((Object)clock);
        }
        session.getTransaction().commit();
        session.clear();
    }

    @After
    public void deleteEntities() throws Exception {
        Session session = this.openSessionWithTenantId(METAMEC_TID);
        this.deleteClocks(session);
        session.close();
        session = this.openSessionWithTenantId(GEOCHRON_TID);
        this.deleteClocks(session);
        session.close();
    }

    private void deleteClocks(Session session) {
        session.beginTransaction();
        List clocks = session.createCriteria(Clock.class).list();
        for (Clock clock : clocks) {
            session.delete((Object)clock);
        }
        session.getTransaction().commit();
        session.clear();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Clock.class};
    }

    @Override
    public Set<String> multiTenantIds() {
        return Collections.set((Object[])new String[]{METAMEC_TID, GEOCHRON_TID});
    }
}

