/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import java.util.List;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.bridge.Student;
import org.hibernate.search.test.bridge.Teacher;
import org.hibernate.search.testsupport.TestConstants;
import org.junit.Assert;
import org.junit.Test;

public class ClassBridgeAndProjectionTest
extends SearchTestBase {
    @Test
    public void testClassBridgeProjection() throws Exception {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        Teacher teacher = new Teacher();
        teacher.setName("John Smith");
        s.persist((Object)teacher);
        Student student1 = new Student();
        student1.setGrade("foo");
        student1.setName("Jack Miller");
        student1.setTeacher(teacher);
        teacher.getStudents().add(student1);
        s.persist((Object)student1);
        Student student2 = new Student();
        student2.setGrade("bar");
        student2.setName("Steve Marshall");
        student2.setTeacher(teacher);
        teacher.getStudents().add(student2);
        s.persist((Object)student2);
        tx.commit();
        tx = s.beginTransaction();
        FullTextSession ftSession = Search.getFullTextSession((Session)s);
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "name", TestConstants.standardAnalyzer);
        FullTextQuery query = ftSession.createFullTextQuery(parser.parse("name:John"), new Class[]{Teacher.class});
        List results = query.list();
        Assert.assertNotNull((Object)results);
        Assert.assertTrue((results.size() == 1 ? 1 : 0) != 0);
        query.setProjection(new String[]{"amount_of_students"});
        results = query.list();
        Assert.assertNotNull((Object)results);
        Assert.assertTrue((results.size() == 1 ? 1 : 0) != 0);
        Object[] firstResult = (Object[])results.get(0);
        Integer amountStudents = (Integer)firstResult[0];
        Assert.assertEquals((Object)2, (Object)amountStudents);
        tx.commit();
        s.close();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Student.class, Teacher.class};
    }
}

