/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration.indexingStrategy;

import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.hibernate.Session;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.test.SearchTestBase;
import org.junit.Assert;
import org.junit.Test;

public class ManualIndexingStrategyTest
extends SearchTestBase {
    @Test
    public void testMultipleEntitiesPerIndex() throws Exception {
        this.indexTestEntity();
        Assert.assertEquals((String)"Due to manual indexing being enabled no automatic indexing should have occurred", (long)0L, (long)this.getDocumentNbr());
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{TestEntity.class};
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.indexing_strategy", "manual");
    }

    private void indexTestEntity() {
        Session session = this.getSessionFactory().openSession();
        session.getTransaction().begin();
        session.persist((Object)new TestEntity());
        session.getTransaction().commit();
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDocumentNbr() throws Exception {
        try (DirectoryReader reader = IndexReader.open((Directory)this.getDirectory(TestEntity.class));){
            int n = reader.numDocs();
            return n;
        }
    }

    @Indexed
    @Entity
    @Table(name="TestEntity")
    public static class TestEntity {
        @Id
        @GeneratedValue
        private int id;
    }
}

