/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.nested;

import java.io.Serializable;
import java.util.List;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.embedded.nested.Address;
import org.hibernate.search.test.embedded.nested.Attribute;
import org.hibernate.search.test.embedded.nested.AttributeValue;
import org.hibernate.search.test.embedded.nested.Person;
import org.hibernate.search.test.embedded.nested.Place;
import org.hibernate.search.test.embedded.nested.Product;
import org.hibernate.search.testsupport.TestConstants;
import org.junit.Assert;
import org.junit.Test;

public class NestedEmbeddedTest
extends SearchTestBase {
    @Test
    public void testNestedEmbeddedIndexing() throws Exception {
        Product product = new Product();
        Attribute attribute = new Attribute(product);
        product.setAttribute(attribute);
        AttributeValue value = new AttributeValue(attribute, "foo");
        attribute.setValue(value);
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)product);
        tx.commit();
        FullTextSession session = Search.getFullTextSession((Session)s);
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "attributes.values.value", TestConstants.standardAnalyzer);
        Query query = parser.parse("foo");
        List result = session.createFullTextQuery(query, new Class[0]).list();
        Assert.assertEquals((String)"unable to find property in attribute value", (long)1L, (long)result.size());
        s.clear();
        tx = s.beginTransaction();
        product = (Product)s.get(Product.class, (Serializable)Long.valueOf(product.getId()));
        product.getAttributes().get(0).getValues().get(0).setValue("bar");
        tx.commit();
        s.clear();
        session = Search.getFullTextSession((Session)s);
        tx = s.beginTransaction();
        query = parser.parse("foo");
        result = session.createFullTextQuery(query, new Class[]{Product.class}).list();
        Assert.assertEquals((String)"change in embedded not reflected in root index", (long)0L, (long)result.size());
        query = parser.parse("bar");
        result = session.createFullTextQuery(query, new Class[]{Product.class}).list();
        Assert.assertEquals((String)"change in embedded not reflected in root index", (long)1L, (long)result.size());
        tx.commit();
        s.close();
    }

    @Test
    public void testNestedEmbeddedIndexingWithContainedInOnCollection() throws Exception {
        Person john = new Person("John Doe");
        Place eiffelTower = new Place("Eiffel Tower");
        Address addressEiffel = new Address("Avenue Gustave Eiffel", "London");
        addressEiffel.addPlace(eiffelTower);
        eiffelTower.setAddress(addressEiffel);
        john.addPlaceVisited(eiffelTower);
        eiffelTower.visitedBy(john);
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)john);
        tx.commit();
        FullTextSession session = Search.getFullTextSession((Session)s);
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "placesVisited.address.city", TestConstants.standardAnalyzer);
        Query query = parser.parse("London");
        List result = session.createFullTextQuery(query, new Class[0]).list();
        Assert.assertEquals((String)"unable to find nested indexed value", (long)1L, (long)result.size());
        s.clear();
        tx = s.beginTransaction();
        john = (Person)s.get(Person.class, (Serializable)Long.valueOf(john.getId()));
        john.getPlacesVisited().get(0).getAddress().setCity("Paris");
        tx.commit();
        s.clear();
        john = (Person)s.get(Person.class, (Serializable)Long.valueOf(john.getId()));
        session = Search.getFullTextSession((Session)s);
        tx = s.beginTransaction();
        query = parser.parse("London");
        result = session.createFullTextQuery(query, new Class[]{Person.class}).list();
        Assert.assertEquals((String)"change in embedded not reflected in root index", (long)0L, (long)result.size());
        query = parser.parse("Paris");
        result = session.createFullTextQuery(query, new Class[]{Person.class}).list();
        Assert.assertEquals((String)"change in embedded not reflected in root index", (long)1L, (long)result.size());
        tx.commit();
        session.close();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Product.class, Attribute.class, AttributeValue.class, Person.class, Place.class, Address.class};
    }
}

