/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.update;

import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.embedded.update.ProductArticle;
import org.hibernate.search.test.embedded.update.ProductModel;
import org.hibernate.search.test.embedded.update.ProductReferenceCode;
import org.hibernate.search.test.embedded.update.ProductShootingBrief;
import org.hibernate.search.test.embedded.update.SimpleChildEntity;
import org.hibernate.search.test.embedded.update.SimpleParentEntity;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1573")
public class ContainedInWithoutIndexedEmbeddedReindexPropagationTest
extends SearchTestBase {
    @Test
    public void testUpdatingContainedInEntityPropagatesToAllEntitiesSimpleCase() throws Exception {
        FullTextSession session = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = session.beginTransaction();
        SimpleParentEntity parent = new SimpleParentEntity("name1");
        session.save((Object)parent);
        SimpleChildEntity child = new SimpleChildEntity(parent);
        session.save((Object)child);
        parent.setChild(child);
        session.update((Object)parent);
        tx.commit();
        session.close();
        session = Search.getFullTextSession((Session)this.openSession());
        tx = session.beginTransaction();
        Assert.assertEquals((long)1L, (long)this.getSimpleChildEntitiesFromIndex(session, parent.getName()).size());
        tx.commit();
        session.close();
        session = Search.getFullTextSession((Session)this.openSession());
        tx = session.beginTransaction();
        parent.setName("newname2");
        session.update((Object)parent);
        tx.commit();
        session.close();
        session = Search.getFullTextSession((Session)this.openSession());
        tx = session.beginTransaction();
        Assert.assertEquals((long)1L, (long)this.getSimpleChildEntitiesFromIndex(session, parent.getName()).size());
        tx.commit();
        session.close();
    }

    @Test
    public void testUpdatingContainedInEntityPropagatesToAllEntitiesBusinessCase() throws Exception {
        ProductModel model = new ProductModel("042024N");
        ProductArticle article1 = new ProductArticle(model, "02");
        ProductArticle article2 = new ProductArticle(model, "E3");
        ProductShootingBrief shootingBrief1 = new ProductShootingBrief("Shooting brief 1");
        ProductShootingBrief shootingBrief2 = new ProductShootingBrief("Shooting brief 2");
        FullTextSession session = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = session.beginTransaction();
        session.save((Object)shootingBrief1);
        session.save((Object)shootingBrief2);
        model.setShootingBrief(shootingBrief1);
        article2.setShootingBrief(shootingBrief2);
        session.save((Object)model);
        session.save((Object)article1);
        session.save((Object)article2);
        tx.commit();
        session.close();
        session = Search.getFullTextSession((Session)this.openSession());
        tx = session.beginTransaction();
        Assert.assertEquals((long)2L, (long)this.getShootingBriefsFromIndex(session, model.getMainReferenceCode().getRawValue()).size());
        tx.commit();
        session.close();
        session = Search.getFullTextSession((Session)this.openSession());
        tx = session.beginTransaction();
        model.getAdditionalReferenceCodes().add(new ProductReferenceCode(model, "NEWREF"));
        session.update((Object)model);
        tx.commit();
        session.close();
        session = Search.getFullTextSession((Session)this.openSession());
        tx = session.beginTransaction();
        Assert.assertEquals((long)1L, (long)this.getShootingBriefsFromIndex(session, "NEWREF").size());
        tx.commit();
        session.close();
    }

    private List<SimpleChildEntity> getSimpleChildEntitiesFromIndex(FullTextSession session, String name) {
        FullTextQuery q = session.createFullTextQuery((Query)new TermQuery(new Term("parentName", name)), new Class[]{SimpleChildEntity.class});
        List results = q.list();
        return results;
    }

    private List<ProductShootingBrief> getShootingBriefsFromIndex(FullTextSession session, String referenceCode) {
        FullTextQuery q = session.createFullTextQuery((Query)new WildcardQuery(new Term("referenceCodeCollection", referenceCode.toLowerCase() + "*")), new Class[]{ProductShootingBrief.class});
        List results = q.list();
        return results;
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{SimpleParentEntity.class, SimpleChildEntity.class, ProductArticle.class, ProductModel.class, ProductReferenceCode.class, ProductShootingBrief.class};
    }
}

