/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine;

import java.io.Serializable;
import java.util.Map;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.engine.BusLine;
import org.hibernate.search.test.engine.BusStop;
import org.hibernate.search.test.engine.LazyCollectionsUpdatingTest;
import org.hibernate.search.testsupport.backend.LeakingLuceneBackend;
import org.junit.Assert;
import org.junit.Test;

public class SkipIndexingWorkForUnaffectingChangesTest
extends SearchTestBase {
    @Test
    public void testUnindexedFieldsDontTriggerEngine() {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        BusLine line1 = new BusLine();
        line1.setBusLineCode(1);
        line1.setBusLineName("Line Uno");
        LazyCollectionsUpdatingTest.addBusStop(line1, "Gateshead");
        LazyCollectionsUpdatingTest.addBusStop(line1, "The Sage");
        this.getSession().persist((Object)line1);
        tx.commit();
        Assert.assertEquals((long)1L, (long)LeakingLuceneBackend.getLastProcessedQueue().size());
        LeakingLuceneBackend.reset();
        fullTextSession.clear();
        tx = fullTextSession.beginTransaction();
        line1 = (BusLine)fullTextSession.load(BusLine.class, (Serializable)line1.getId());
        line1.setBusLineCode(2);
        line1.setOperating(true);
        BusStop busStop = line1.getStops().iterator().next();
        busStop.setServiceComments("please clean the garbage after the football match");
        tx.commit();
        if (this.isDirtyCheckEnabled()) {
            Assert.assertEquals((long)0L, (long)LeakingLuceneBackend.getLastProcessedQueue().size());
        } else {
            Assert.assertEquals((long)1L, (long)LeakingLuceneBackend.getLastProcessedQueue().size());
        }
        LeakingLuceneBackend.reset();
        fullTextSession.clear();
        tx = fullTextSession.beginTransaction();
        busStop = (BusStop)fullTextSession.load(BusStop.class, (Serializable)busStop.getId());
        busStop.setRoadName("Mill Road");
        tx.commit();
        Assert.assertEquals((long)1L, (long)LeakingLuceneBackend.getLastProcessedQueue().size());
        LeakingLuceneBackend.reset();
        fullTextSession.clear();
        tx = fullTextSession.beginTransaction();
        busStop = (BusStop)fullTextSession.load(BusStop.class, (Serializable)busStop.getId());
        busStop.getStartingDate().setTime(0L);
        tx.commit();
        Assert.assertEquals((long)1L, (long)LeakingLuceneBackend.getLastProcessedQueue().size());
        LeakingLuceneBackend.reset();
        fullTextSession.close();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{BusLine.class, BusStop.class};
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.analyzer", SimpleAnalyzer.class.getName());
        cfg.put("hibernate.search.default.worker.backend", LeakingLuceneBackend.class.getName());
    }

    protected boolean isDirtyCheckEnabled() {
        return true;
    }
}

