/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.envers;

import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.envers.AuditReader;
import org.hibernate.envers.AuditReaderFactory;
import org.hibernate.envers.query.AuditEntity;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.envers.Address;
import org.hibernate.search.test.envers.Person;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Test;

public class SearchAndEnversIntegrationTest
extends SearchTestBase {
    private Person harryPotter;
    private Person hermioneGranger;
    private Address privetDrive;
    private Address grimmauldPlace;

    @TestForIssue(jiraKey="HSEARCH-1293")
    @Test
    public void testHibernateSearchAndEnversIntegration() {
        this.atRevision1();
        this.atRevision2();
        this.atRevision3();
        this.atRevision4();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void atRevision1() {
        Transaction tx;
        this.privetDrive = new Address("Privet Drive", 121);
        this.privetDrive.setFlatNumber(2);
        this.harryPotter = new Person("Harry", "Potter", this.privetDrive);
        this.grimmauldPlace = new Address("Grimmauld Place", 12);
        this.hermioneGranger = new Person("Hermione", "Granger", this.grimmauldPlace);
        try (FullTextSession session = Search.getFullTextSession((Session)this.openSession());){
            tx = session.beginTransaction();
            session.save((Object)this.privetDrive);
            session.save((Object)this.grimmauldPlace);
            session.save((Object)this.harryPotter);
            session.save((Object)this.hermioneGranger);
            tx.commit();
        }
        session = Search.getFullTextSession((Session)this.openSession());
        try {
            tx = session.beginTransaction();
            AuditReader auditReader = AuditReaderFactory.get((Session)session);
            Assert.assertEquals((Object)1, (Object)this.findLastRevisionForEntity(auditReader, Person.class));
            Assert.assertEquals((Object)1, (Object)this.findLastRevisionForEntity(auditReader, Address.class));
            Assert.assertEquals((long)2L, (long)this.howManyEntitiesChangedAtRevisionNumber(auditReader, Person.class, 1));
            Assert.assertEquals((long)2L, (long)this.howManyEntitiesChangedAtRevisionNumber(auditReader, Address.class, 1));
            Assert.assertEquals((long)2L, (long)this.howManyAuditedObjectsSoFar(auditReader, Person.class));
            Assert.assertEquals((long)2L, (long)this.howManyAuditedObjectsSoFar(auditReader, Address.class));
            Person hermioneFromHibSearch = this.findPersonFromIndexBySurname(session, "Granger");
            Person hermioneAtRevision1 = this.findPersonFromAuditBySurname(auditReader, "Granger");
            Assert.assertEquals((Object)hermioneFromHibSearch, (Object)hermioneAtRevision1);
            Person harryFromHibSearch = this.findPersonFromIndexBySurname(session, "Potter");
            Person harryAtRevision1 = this.findPersonFromAuditBySurname(auditReader, "Potter");
            Assert.assertEquals((Object)harryFromHibSearch, (Object)harryAtRevision1);
            tx.commit();
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void atRevision2() {
        Transaction tx;
        try (FullTextSession session = Search.getFullTextSession((Session)this.openSession());){
            tx = session.beginTransaction();
            this.privetDrive = (Address)session.merge((Object)this.privetDrive);
            this.privetDrive.setHouseNumber(5);
            this.privetDrive.setFlatNumber(null);
            tx.commit();
        }
        session = Search.getFullTextSession((Session)this.openSession());
        try {
            tx = session.beginTransaction();
            AuditReader auditReader = AuditReaderFactory.get((Session)session);
            Assert.assertEquals((Object)1, (Object)this.findLastRevisionForEntity(auditReader, Person.class));
            Assert.assertEquals((Object)2, (Object)this.findLastRevisionForEntity(auditReader, Address.class));
            Assert.assertEquals((long)0L, (long)this.howManyEntitiesChangedAtRevisionNumber(auditReader, Person.class, 2));
            Assert.assertEquals((long)1L, (long)this.howManyEntitiesChangedAtRevisionNumber(auditReader, Address.class, 2));
            Assert.assertEquals((long)2L, (long)this.howManyAuditedObjectsSoFar(auditReader, Person.class));
            Assert.assertEquals((long)3L, (long)this.howManyAuditedObjectsSoFar(auditReader, Address.class));
            List houseNumberAddressChangedAtRevision2 = auditReader.createQuery().forEntitiesModifiedAtRevision(Address.class, (Number)2).add(AuditEntity.property((String)"houseNumber").hasChanged()).add(AuditEntity.property((String)"flatNumber").hasChanged()).add(AuditEntity.property((String)"streetName").hasNotChanged()).getResultList();
            Assert.assertEquals((long)1L, (long)houseNumberAddressChangedAtRevision2.size());
            List<Person> peopleLivingInPrivetDriveFromHibSearch = this.findPeopleFromIndexByStreetName(session, "Privet");
            Assert.assertEquals((long)1L, (long)peopleLivingInPrivetDriveFromHibSearch.size());
            Person harryFromHibSearch = peopleLivingInPrivetDriveFromHibSearch.get(0);
            Person harryAtRevision2 = this.findPersonFromAuditBySurname(auditReader, "Potter");
            Assert.assertEquals((Object)harryFromHibSearch, (Object)harryAtRevision2);
            tx.commit();
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void atRevision3() {
        Transaction tx;
        try (FullTextSession session = Search.getFullTextSession((Session)this.openSession());){
            tx = session.beginTransaction();
            this.hermioneGranger = (Person)session.merge((Object)this.hermioneGranger);
            this.hermioneGranger.setAddress(this.privetDrive);
            tx.commit();
        }
        session = Search.getFullTextSession((Session)this.openSession());
        try {
            tx = session.beginTransaction();
            AuditReader auditReader = AuditReaderFactory.get((Session)session);
            List peopleWhoHasMovedHouseAtRevision3 = auditReader.createQuery().forEntitiesModifiedAtRevision(Person.class, (Number)3).add(AuditEntity.property((String)"address").hasChanged()).getResultList();
            Assert.assertEquals((long)1L, (long)peopleWhoHasMovedHouseAtRevision3.size());
            Assert.assertEquals((Object)3, (Object)this.findLastRevisionForEntity(auditReader, Person.class));
            Assert.assertEquals((Object)3, (Object)this.findLastRevisionForEntity(auditReader, Address.class));
            Assert.assertEquals((long)1L, (long)this.howManyEntitiesChangedAtRevisionNumber(auditReader, Person.class, 3));
            Assert.assertEquals((long)2L, (long)this.howManyEntitiesChangedAtRevisionNumber(auditReader, Address.class, 3));
            Assert.assertEquals((long)3L, (long)this.howManyAuditedObjectsSoFar(auditReader, Person.class));
            Assert.assertEquals((long)5L, (long)this.howManyAuditedObjectsSoFar(auditReader, Address.class));
            List<Person> peopleLivingInPrivetDriveFromHibSearch = this.findPeopleFromIndexByStreetName(session, "Privet");
            Assert.assertEquals((long)2L, (long)peopleLivingInPrivetDriveFromHibSearch.size());
            tx.commit();
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void atRevision4() {
        Transaction tx;
        try (FullTextSession session = Search.getFullTextSession((Session)this.openSession());){
            tx = session.beginTransaction();
            session.delete((Object)this.harryPotter);
            session.delete((Object)this.hermioneGranger);
            session.delete((Object)this.grimmauldPlace);
            session.delete((Object)this.privetDrive);
            tx.commit();
        }
        session = Search.getFullTextSession((Session)this.openSession());
        try {
            tx = session.beginTransaction();
            AuditReader auditReader = AuditReaderFactory.get((Session)session);
            Assert.assertEquals((Object)4, (Object)this.findLastRevisionForEntity(auditReader, Person.class));
            Assert.assertEquals((Object)4, (Object)this.findLastRevisionForEntity(auditReader, Address.class));
            Assert.assertEquals((long)2L, (long)this.howManyEntitiesChangedAtRevisionNumber(auditReader, Person.class, 4));
            Assert.assertEquals((long)2L, (long)this.howManyEntitiesChangedAtRevisionNumber(auditReader, Address.class, 4));
            Assert.assertEquals((long)7L, (long)this.howManyAuditedObjectsSoFar(auditReader, Address.class));
            Assert.assertEquals((long)5L, (long)this.howManyAuditedObjectsSoFar(auditReader, Person.class));
            Assert.assertNull((Object)this.findPersonFromIndexBySurname(session, "Potter"));
            Assert.assertNull((Object)this.findPersonFromIndexBySurname(session, "Granger"));
            Assert.assertEquals((long)0L, (long)this.findPeopleFromIndexByStreetName(session, "Privet").size());
            Assert.assertEquals((long)0L, (long)this.findPeopleFromIndexByStreetName(session, "Guillaume").size());
            tx.commit();
        }
        finally {
            session.close();
        }
    }

    private int howManyEntitiesChangedAtRevisionNumber(AuditReader auditReader, Class<?> clazz, Number revision) {
        return ((Long)auditReader.createQuery().forEntitiesModifiedAtRevision(clazz, revision).addProjection(AuditEntity.id().count()).getSingleResult()).intValue();
    }

    private int howManyAuditedObjectsSoFar(AuditReader auditReader, Class<?> clazz) {
        return auditReader.createQuery().forRevisionsOfEntity(clazz, true, true).getResultList().size();
    }

    private Number findLastRevisionForEntity(AuditReader auditReader, Class<?> clazz) {
        return (Number)auditReader.createQuery().forRevisionsOfEntity(clazz, false, true).addProjection(AuditEntity.revisionNumber().max()).getSingleResult();
    }

    private Person findPersonFromAuditBySurname(AuditReader auditReader, String value) {
        return (Person)auditReader.createQuery().forEntitiesAtRevision(Person.class, (Number)1).add(AuditEntity.property((String)"surname").eq((Object)value)).getSingleResult();
    }

    private List<Person> findPeopleFromIndex(FullTextSession session, String term, String value) {
        Query luceneQuery = this.createLuceneQuery(term, value);
        return session.createFullTextQuery(luceneQuery, new Class[]{Person.class}).setSort(new Sort(new SortField("surname", SortField.Type.STRING))).list();
    }

    private Person findPersonFromIndexBySurname(FullTextSession session, String surname) {
        List<Person> people = this.findPeopleFromIndex(session, "surname", surname);
        if (people.isEmpty()) {
            return null;
        }
        if (people.size() > 1) {
            throw new RuntimeException("I've found too many people!!!");
        }
        return people.get(0);
    }

    private List<Person> findPeopleFromIndexByStreetName(FullTextSession session, String streetName) {
        return this.findPeopleFromIndex(session, "address.streetName", streetName);
    }

    private Query createLuceneQuery(String term, String value) {
        Query luceneQuery;
        String searchQuery = term + ":" + value;
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), term, (Analyzer)new StopAnalyzer(TestConstants.getTargetLuceneVersion()));
        try {
            luceneQuery = parser.parse(searchQuery);
        }
        catch (ParseException e) {
            throw new RuntimeException("Unable to parse query", e);
        }
        return luceneQuery;
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Person.class, Address.class};
    }
}

