/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.fieldcache;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.engine.Country;
import org.hibernate.search.test.engine.Location;
import org.hibernate.search.test.engine.PinPoint;
import org.hibernate.search.testsupport.readerprovider.FieldSelectorLeakingReaderProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CachedNumericIdTest
extends SearchTestBase {
    private static final int NUM_LOCATIONS = 50;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.prepareData();
    }

    @Test
    public void testLocationLoading() {
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        QueryBuilder queryBuilder = this.getSearchFactory().buildQueryBuilder().forEntity(Location.class).get();
        Query query = queryBuilder.all().createQuery();
        FieldSelectorLeakingReaderProvider.resetFieldSelector();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{Location.class});
        fullTextQuery.setSort(new Sort(new SortField("description", SortField.Type.STRING)));
        List locations = fullTextQuery.list();
        FieldSelectorLeakingReaderProvider.assertFieldSelectorDisabled();
        Assert.assertEquals((long)50L, (long)locations.size());
        for (Location location : locations) {
            int id = location.getId();
            Assert.assertEquals((Object)(String.valueOf(id) + "42"), (Object)location.getDescription());
        }
        tx.commit();
        session.close();
    }

    private void prepareData() {
        Session session = this.openSession();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        Transaction transaction = fullTextSession.beginTransaction();
        Country italy = new Country("Italy", 39.0);
        for (int i = 0; i < 50; ++i) {
            session.persist((Object)new Location(i, Long.valueOf(i), 7 * i, Double.valueOf(9 * i), 100 - i, String.valueOf(i) + "42", null, italy, BigDecimal.ONE, 5, 10));
        }
        transaction.commit();
        session.close();
    }

    private void cleanData() {
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        session.createQuery("delete Location").executeUpdate();
        tx.commit();
        session.close();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.cleanData();
        super.tearDown();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{PinPoint.class, Location.class};
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.default.indexwriter.transaction.max_merge_docs", "10");
        cfg.put("hibernate.search.default.reader.strategy", FieldSelectorLeakingReaderProvider.class.getName());
    }
}

