/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.spatial;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.engine.spi.FacetManager;
import org.hibernate.search.query.facet.FacetSortOrder;
import org.hibernate.search.query.facet.FacetingRequest;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.spatial.impl.Rectangle;
import org.hibernate.search.spatial.impl.SpatialQueryBuilderFromCoordinates;
import org.hibernate.search.test.spatial.POI;

public final class BenchWithGeonames {
    private static final String hibernateConfigurationFile = "/org/hibernate/search/test/spatial/hibernate.cfg.xml";
    private static final String geonamesDataFile = "FR.txt";

    private BenchWithGeonames() {
    }

    public static void main(String[] args) {
        BenchWithGeonames.LoadGeonames();
        BenchWithGeonames.Bench();
        BenchWithGeonames.FacetTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LoadGeonames() {
        Session session = null;
        FullTextSession fullTextSession = null;
        BufferedReader buffRead = null;
        SessionFactory sessionFactory = null;
        try {
            sessionFactory = new Configuration().configure(hibernateConfigurationFile).buildSessionFactory();
            session = sessionFactory.openSession();
            session.createSQLQuery("delete from MemberLevelTestPoI").executeUpdate();
            session.beginTransaction();
            fullTextSession = Search.getFullTextSession((Session)session);
            File geonamesFile = new File(geonamesDataFile);
            buffRead = new BufferedReader(new FileReader(geonamesFile));
            String line = null;
            int line_number = 0;
            while ((line = buffRead.readLine()) != null) {
                String[] data = line.split("\t");
                POI current = new POI(Integer.parseInt(data[0]), data[1], Double.parseDouble(data[4]), Double.parseDouble(data[5]), data[7]);
                session.save((Object)current);
                if (line_number % 10000 == 0) {
                    fullTextSession.flushToIndexes();
                    session.getTransaction().commit();
                    session.close();
                    session = sessionFactory.openSession();
                    fullTextSession = Search.getFullTextSession((Session)session);
                    session.beginTransaction();
                    System.out.println(Integer.toString(line_number));
                }
                ++line_number;
            }
            session.getTransaction().commit();
            fullTextSession.close();
            sessionFactory.close();
            buffRead.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fullTextSession != null && fullTextSession.isOpen()) {
                Transaction transaction = fullTextSession.getTransaction();
                if (transaction != null && transaction.getStatus() == TransactionStatus.ACTIVE) {
                    transaction.rollback();
                }
                fullTextSession.close();
            }
            if (sessionFactory != null && !sessionFactory.isClosed()) {
                sessionFactory.close();
            }
            try {
                if (buffRead != null) {
                    buffRead.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Bench() {
        Session session = null;
        FullTextSession fullTextSession = null;
        SessionFactory sessionFactory = null;
        try {
            sessionFactory = new Configuration().configure(hibernateConfigurationFile).buildSessionFactory();
            session = sessionFactory.openSession();
            session.beginTransaction();
            fullTextSession = Search.getFullTextSession((Session)session);
            long spatialHashTotalDuration = 0L;
            long spatialTotalDuration = 0L;
            long doubleRangeTotalDuration = 0L;
            long distanceDoubleRangeTotalDuration = 0L;
            long spatialHashDocsFetched = 0L;
            long spatialDocsFetched = 0L;
            long doubleRangeDocsFetched = 0L;
            long distanceDoubleRangeDocsFetched = 0L;
            QueryBuilder queryBuilder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(POI.class).get();
            Integer iterations = 2000;
            Integer warmUp = 50;
            Random random = new Random(42L);
            for (int i = 0; i < iterations; ++i) {
                long endTime;
                Point center = Point.fromDegrees((double)(random.nextDouble() * 2.0 + 44.0), (double)(random.nextDouble() * 2.0 + 3.0));
                double radius = 25.0;
                Rectangle boundingBox = Rectangle.fromBoundingCircle((Coordinates)center, (double)radius);
                Query query = queryBuilder.bool().must(queryBuilder.range().onField("latitude").from((Object)boundingBox.getLowerLeft().getLatitude()).to((Object)boundingBox.getUpperRight().getLatitude()).createQuery()).must(queryBuilder.range().onField("longitude").from((Object)boundingBox.getLowerLeft().getLongitude()).to((Object)boundingBox.getUpperRight().getLongitude()).createQuery()).createQuery();
                FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{POI.class});
                hibQuery.setProjection(new String[]{"id", "name"});
                long startTime = System.nanoTime();
                try {
                    doubleRangeDocsFetched += (long)hibQuery.getResultSize();
                }
                finally {
                    endTime = System.nanoTime();
                }
                long duration = endTime - startTime;
                if (i > warmUp) {
                    doubleRangeTotalDuration += duration;
                }
                session.clear();
                query = queryBuilder.bool().must(queryBuilder.range().onField("latitude").from((Object)boundingBox.getLowerLeft().getLatitude()).to((Object)boundingBox.getUpperRight().getLatitude()).createQuery()).must(queryBuilder.range().onField("longitude").from((Object)boundingBox.getLowerLeft().getLongitude()).to((Object)boundingBox.getUpperRight().getLongitude()).createQuery()).createQuery();
                ConstantScoreQuery filteredQuery = new ConstantScoreQuery(SpatialQueryBuilderFromCoordinates.buildDistanceFilter((Filter)new QueryWrapperFilter(query), (Coordinates)center, (double)radius, (String)"location"));
                hibQuery = fullTextSession.createFullTextQuery((Query)filteredQuery, new Class[]{POI.class});
                hibQuery.setProjection(new String[]{"id", "name"});
                startTime = System.nanoTime();
                try {
                    distanceDoubleRangeDocsFetched += (long)hibQuery.getResultSize();
                }
                finally {
                    endTime = System.nanoTime();
                }
                duration = endTime - startTime;
                if (i > warmUp) {
                    distanceDoubleRangeTotalDuration += duration;
                }
                List rangeResults = hibQuery.list();
                session.clear();
                Query luceneQuery = SpatialQueryBuilderFromCoordinates.buildSpatialHashQuery((Coordinates)center, (double)radius, (String)"location");
                hibQuery = fullTextSession.createFullTextQuery(luceneQuery, new Class[]{POI.class});
                hibQuery.setProjection(new String[]{"id", "name"});
                startTime = System.nanoTime();
                try {
                    spatialHashDocsFetched += (long)hibQuery.getResultSize();
                }
                finally {
                    endTime = System.nanoTime();
                }
                duration = endTime - startTime;
                if (i > warmUp) {
                    spatialHashTotalDuration += duration;
                }
                session.clear();
                luceneQuery = SpatialQueryBuilderFromCoordinates.buildSpatialQueryByHash((Coordinates)center, (double)radius, (String)"location");
                hibQuery = fullTextSession.createFullTextQuery(luceneQuery, new Class[]{POI.class});
                hibQuery.setProjection(new String[]{"id", "name"});
                startTime = System.nanoTime();
                try {
                    spatialDocsFetched += (long)hibQuery.getResultSize();
                }
                finally {
                    endTime = System.nanoTime();
                }
                duration = endTime - startTime;
                if (i > warmUp) {
                    spatialTotalDuration += duration;
                }
                List spatialHashResults = hibQuery.list();
                session.clear();
                if (rangeResults.size() == spatialHashResults.size()) continue;
                luceneQuery = SpatialQueryBuilderFromCoordinates.buildDistanceQuery((Coordinates)center, (double)radius, (String)"location");
                hibQuery = fullTextSession.createFullTextQuery(luceneQuery, new Class[]{POI.class});
                hibQuery.setProjection(new String[]{"id", "name"});
                System.out.println(">>>>> Different numbers of documents fetched for point (" + Double.toString(center.getLatitude()) + "," + Double.toString(center.getLongitude()) + ") and radius " + Double.toString(radius));
                System.out.println("Range results : " + rangeResults);
                System.out.println("Spatial Hash results : " + spatialHashResults);
                System.out.println("Pure distance results : " + hibQuery.getResultSize());
                ArrayList<Integer> rangeIds = new ArrayList<Integer>();
                for (int index = 0; index < rangeResults.size(); ++index) {
                    rangeIds.add((Integer)((Object[])rangeResults.get(index))[0]);
                }
                ArrayList<Integer> spatialHashIds = new ArrayList<Integer>();
                for (int index = 0; index < spatialHashResults.size(); ++index) {
                    spatialHashIds.add((Integer)((Object[])spatialHashResults.get(index))[0]);
                }
                rangeIds.removeAll(spatialHashIds);
                System.out.println("Missing Ids : " + rangeIds);
            }
            session.getTransaction().commit();
            session.close();
            sessionFactory.close();
            System.out.println("Mean time with Spatial Hash : " + Double.toString((double)spatialHashTotalDuration * Math.pow(10.0, -6.0) / (double)(iterations - warmUp)) + " ms. Average number of docs fetched : " + Double.toString((double)spatialHashDocsFetched / ((double)(iterations - warmUp) * 1.0)));
            System.out.println("Mean time with Spatial Hash + Distance filter : " + Double.toString((double)spatialTotalDuration * Math.pow(10.0, -6.0) / (double)(iterations - warmUp)) + " ms. Average number of docs fetched : " + Double.toString((double)spatialDocsFetched / ((double)(iterations - warmUp) * 1.0)));
            System.out.println("Mean time with DoubleRange : " + Double.toString((double)doubleRangeTotalDuration * Math.pow(10.0, -6.0) / (double)(iterations - warmUp)) + " ms. Average number of docs fetched : " + Double.toString((double)doubleRangeDocsFetched / ((double)(iterations - warmUp) * 1.0)));
            System.out.println("Mean time with DoubleRange + Distance filter : " + Double.toString((double)distanceDoubleRangeTotalDuration * Math.pow(10.0, -6.0) / (double)(iterations - warmUp)) + " ms. Average number of docs fetched : " + Double.toString((double)distanceDoubleRangeDocsFetched / ((double)(iterations - warmUp) * 1.0)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fullTextSession != null && fullTextSession.isOpen()) {
                Transaction transaction = fullTextSession.getTransaction();
                if (transaction != null && transaction.getStatus() == TransactionStatus.ACTIVE) {
                    transaction.rollback();
                }
                fullTextSession.close();
            }
            if (sessionFactory != null && !sessionFactory.isClosed()) {
                sessionFactory.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void FacetTest() {
        Session session = null;
        FullTextSession fullTextSession = null;
        SessionFactory sessionFactory = null;
        try {
            sessionFactory = new Configuration().configure(hibernateConfigurationFile).buildSessionFactory();
            session = sessionFactory.openSession();
            session.beginTransaction();
            fullTextSession = Search.getFullTextSession((Session)session);
            Point center = Point.fromDegrees((double)46.0, (double)4.0);
            double radius = 50.0;
            Query luceneQuery = SpatialQueryBuilderFromCoordinates.buildSpatialQueryByHash((Coordinates)center, (double)radius, (String)"location");
            FullTextQuery hibQuery = fullTextSession.createFullTextQuery(luceneQuery, new Class[]{POI.class});
            hibQuery.setProjection(new String[]{"id", "name", "type"});
            FacetManager facetManager = hibQuery.getFacetManager();
            QueryBuilder queryBuilder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(POI.class).get();
            FacetingRequest facetingRequest = queryBuilder.facet().name("typeFacet").onField("type").discrete().orderedBy(FacetSortOrder.COUNT_DESC).includeZeroCounts(false).createFacetingRequest();
            facetManager.enableFaceting(facetingRequest);
            Integer size = hibQuery.getResultSize();
            List list = hibQuery.list();
            List facets = facetManager.getFacets("typeFacet");
            System.out.println(facets);
            session.getTransaction().commit();
            session.close();
            sessionFactory.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fullTextSession != null && fullTextSession.isOpen()) {
                Transaction transaction = fullTextSession.getTransaction();
                if (transaction != null && transaction.getStatus() == TransactionStatus.ACTIVE) {
                    transaction.rollback();
                }
                fullTextSession.close();
            }
            if (sessionFactory != null && !sessionFactory.isClosed()) {
                sessionFactory.close();
            }
        }
    }
}

