/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import java.util.Date;
import java.util.List;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.bridge.MapBridgeTestEntity;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MapBridgeTest
extends SearchTestBase {
    private FullTextSession fullTextSession;
    private MapBridgeTestEntity withoutNull;
    private MapBridgeTestEntity withNullEntry;
    private MapBridgeTestEntity withNullEmbedded;
    private Date indexedDate;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Session session = this.openSession();
        this.fullTextSession = Search.getFullTextSession((Session)session);
        this.prepareData();
    }

    private void prepareData() {
        Transaction tx = this.fullTextSession.beginTransaction();
        this.withoutNull = this.persistEntity((Session)this.fullTextSession, "Davide D'Alto");
        this.withoutNull.addNullIndexed(1, MapBridgeTestEntity.Language.ITALIAN);
        this.withoutNull.addNullIndexed(2, MapBridgeTestEntity.Language.ENGLISH);
        this.withoutNull.addNumericNullIndexed(1, 1);
        this.withoutNull.addNumericNullIndexed(2, 2);
        this.withoutNull.addNullNotIndexed(1, "DaltoValue");
        this.withoutNull.addNullNotIndexed(2, "DavideValue");
        this.withoutNull.addNumericNullNotIndexed(1, 3L);
        this.withoutNull.addNumericNullNotIndexed(2, 4L);
        this.indexedDate = new Date();
        this.withoutNull.addDate(1, this.indexedDate);
        this.withNullEntry = this.persistEntity((Session)this.fullTextSession, "Worf");
        this.withNullEntry.addNullIndexed(1, MapBridgeTestEntity.Language.KLINGON);
        this.withNullEntry.addNullIndexed(2, MapBridgeTestEntity.Language.ENGLISH);
        this.withNullEntry.addNullIndexed(3, null);
        this.withNullEntry.addNumericNullIndexed(1, 11);
        this.withNullEntry.addNumericNullIndexed(2, null);
        this.withNullEntry.addNullNotIndexed(1, "WorfValue");
        this.withNullEntry.addNullNotIndexed(2, null);
        this.withNullEntry.addNumericNullNotIndexed(1, 33L);
        this.withNullEntry.addNumericNullNotIndexed(2, null);
        this.withNullEntry.addDate(1, null);
        this.withNullEmbedded = this.persistEntity((Session)this.fullTextSession, "Mime");
        this.withNullEmbedded.setDates(null);
        this.withNullEmbedded.setNumericNullIndexed(null);
        this.withNullEmbedded.setNumericNullNotIndexed(null);
        this.withNullEmbedded.setNullIndexed(null);
        this.withNullEmbedded.setNullNotIndexed(null);
        this.withNullEmbedded.setDates(null);
        tx.commit();
    }

    @Test
    public void testSearchNullEntry() throws Exception {
        List<MapBridgeTestEntity> results = this.findResults("nullIndexed", "NULL_MARKER", true);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Unexpected number of results in a collection", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned looking for a null in a collection", (Object)this.withNullEntry.getName(), (Object)results.get(0).getName());
    }

    @Test
    public void testSearchNullEmbedded() throws Exception {
        List<MapBridgeTestEntity> results = this.findEmbeddedNullResults("nullIndexed", "EMBEDDED_NULL", true);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Unexpected number of results in a collection", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned looking for a null in a collection", (Object)this.withNullEmbedded.getName(), (Object)results.get(0).getName());
    }

    @Test
    public void testSearchNullNumericEmbedded() throws Exception {
        List<MapBridgeTestEntity> results = this.findEmbeddedNullResults("embeddedNum", "EMBEDDED_NUMERIC_NULL", true);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Unexpected number of results in a collection", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned looking for a null in a collection of numeric", (Object)this.withNullEmbedded.getName(), (Object)results.get(0).getName());
    }

    @Test
    public void testSearchNullNumericEntry() throws Exception {
        List<MapBridgeTestEntity> results = this.findResults("numericNullIndexed", "NULL_NUMERIC_MARKER", false);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Unexpected number of results in a collection", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned looking for a null in a collection of numeric", (Object)this.withNullEntry.getName(), (Object)results.get(0).getName());
    }

    @Test
    public void testSearchNotNullEntry() throws Exception {
        List<MapBridgeTestEntity> results = this.findResults("nullIndexed", (Object)MapBridgeTestEntity.Language.KLINGON, false);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed collection", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned from an indexed collection", (Object)this.withNullEntry.getName(), (Object)results.get(0).getName());
        results = this.findResults("nullIndexed", (Object)MapBridgeTestEntity.Language.ITALIAN, false);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed collection", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned from an indexed collection", (Object)this.withoutNull.getName(), (Object)results.get(0).getName());
        results = this.findResults("nullIndexed", (Object)MapBridgeTestEntity.Language.ENGLISH, false);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed collection", (long)2L, (long)results.size());
    }

    @Test
    public void testSearchEntryWhenNullEntryNotIndexed() throws Exception {
        List<MapBridgeTestEntity> results = this.findResults("nullNotIndexed", "DaltoValue", false);
        Assert.assertNotNull((String)"No result found for an indexed array", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed array", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned from an indexed array", (Object)this.withoutNull.getName(), (Object)results.get(0).getName());
        results = this.findResults("nullNotIndexed", "WorfValue", false);
        Assert.assertNotNull((String)"No result found for an indexed array", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed array", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned from an indexed array", (Object)this.withNullEntry.getName(), (Object)results.get(0).getName());
    }

    @Test
    public void testSearchNotNullNumeric() throws Exception {
        List<MapBridgeTestEntity> results = this.findNumericResults("numericNullIndexed", 1);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed collection", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned from an indexed collection", (Object)this.withoutNull.getName(), (Object)results.get(0).getName());
        results = this.findNumericResults("numericNullIndexed", 11);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed collection", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned from an indexed collection", (Object)this.withNullEntry.getName(), (Object)results.get(0).getName());
    }

    @Test
    public void testSearchNotNullNumericEntryWhenNullEntryNotIndexed() throws Exception {
        List<MapBridgeTestEntity> results = this.findNumericResults("numericNullNotIndexed", 3L);
        Assert.assertNotNull((String)"No result found for an indexed array", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed array", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned from an indexed array", (Object)this.withoutNull.getName(), (Object)results.get(0).getName());
        results = this.findNumericResults("numericNullNotIndexed", 33L);
        Assert.assertNotNull((String)"No result found for an indexed array", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed array", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned from an indexed array", (Object)this.withNullEntry.getName(), (Object)results.get(0).getName());
    }

    @Test
    public void testDateIndexing() throws Exception {
        List<MapBridgeTestEntity> results = this.findResultsWithRangeQuery("dates", DateTools.round((Date)this.indexedDate, (DateTools.Resolution)DateTools.Resolution.SECOND));
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed collection", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned from a collection of Date", (Object)this.withoutNull.getName(), (Object)results.get(0).getName());
    }

    private List<MapBridgeTestEntity> findEmbeddedNullResults(String fieldName, Object value, boolean checkNullToken) {
        QueryBuilder queryBuilder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(MapBridgeTestEntity.class).get();
        TermMatchingContext termMatchingContext = queryBuilder.keyword().onField(fieldName);
        if (checkNullToken) {
            termMatchingContext.ignoreFieldBridge();
        }
        Query query = ((TermMatchingContext)termMatchingContext.ignoreAnalyzer()).matching(value).createQuery();
        return this.fullTextSession.createFullTextQuery(query, new Class[]{MapBridgeTestEntity.class}).list();
    }

    private List<MapBridgeTestEntity> findResults(String fieldName, Object value, boolean checkNullToken) {
        QueryBuilder queryBuilder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(MapBridgeTestEntity.class).get();
        TermMatchingContext termMatchingContext = queryBuilder.keyword().onField(fieldName);
        if (checkNullToken) {
            termMatchingContext.ignoreFieldBridge();
            termMatchingContext.ignoreAnalyzer();
        }
        Query query = termMatchingContext.matching(value).createQuery();
        return this.fullTextSession.createFullTextQuery(query, new Class[]{MapBridgeTestEntity.class}).list();
    }

    private List<MapBridgeTestEntity> findResultsWithRangeQuery(String fieldName, Object start) {
        QueryBuilder queryBuilder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(MapBridgeTestEntity.class).get();
        Query query = queryBuilder.range().onField(fieldName).above(start).createQuery();
        return this.fullTextSession.createFullTextQuery(query, new Class[]{MapBridgeTestEntity.class}).list();
    }

    private List<MapBridgeTestEntity> findNumericResults(String fieldName, Object number) {
        Query query = NumericFieldUtils.createNumericRangeQuery((String)fieldName, (Object)number, (Object)number, (boolean)true, (boolean)true);
        return this.fullTextSession.createFullTextQuery(query, new Class[]{MapBridgeTestEntity.class}).list();
    }

    private MapBridgeTestEntity persistEntity(Session s, String name) {
        MapBridgeTestEntity boy = new MapBridgeTestEntity();
        boy.setName(name);
        s.persist((Object)boy);
        return boy;
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{MapBridgeTestEntity.class};
    }
}

