/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge.tika;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.sql.Blob;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.bridge.tika.Book;
import org.hibernate.search.testsupport.TestConstants;
import org.junit.Assert;
import org.junit.Test;

public class TikaBridgeBlobSupportTest
extends SearchTestBase {
    private static final String TEST_DOCUMENT_PDF = "/org/hibernate/search/test/bridge/tika/test-document-1.pdf";
    private static final String PATH_TO_TEST_DOCUMENT_PDF;

    @Test
    public void testDefaultTikaBridgeWithBlobData() throws Exception {
        Session session = this.openSession();
        this.persistBook(session, this.getBlobData(PATH_TO_TEST_DOCUMENT_PDF, session));
        this.persistBook(session, null);
        this.indexBook(session);
        this.searchBook(session);
        session.close();
    }

    private void searchBook(Session session) throws ParseException {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "content", TestConstants.standardAnalyzer);
        Query query = parser.parse("foo");
        List result = fullTextSession.createFullTextQuery(query, new Class[0]).list();
        Assert.assertEquals((String)"there should be no match", (long)0L, (long)result.size());
        query = parser.parse("Lucene");
        result = fullTextSession.createFullTextQuery(query, new Class[0]).list();
        Assert.assertEquals((String)"there should be match", (long)1L, (long)result.size());
        query = parser.parse("<NULL>");
        result = fullTextSession.createFullTextQuery(query, new Class[0]).list();
        Assert.assertEquals((String)"there should be match", (long)1L, (long)result.size());
        result = fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[0]).list();
        Assert.assertEquals((String)"there should be match", (long)2L, (long)result.size());
    }

    private void persistBook(Session session, Blob data) throws IOException {
        Transaction tx = session.beginTransaction();
        Book book = new Book();
        book.setContent(data);
        session.save((Object)book);
        session.flush();
        tx.commit();
        session.clear();
    }

    void indexBook(Session session) {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        fullTextSession.setFlushMode(FlushMode.MANUAL);
        fullTextSession.setCacheMode(CacheMode.IGNORE);
        Transaction transaction = fullTextSession.beginTransaction();
        int BATCH_SIZE = 10;
        ScrollableResults results = fullTextSession.createCriteria(Book.class).setFetchSize(BATCH_SIZE).scroll(ScrollMode.FORWARD_ONLY);
        int index = 0;
        while (results.next()) {
            fullTextSession.index(results.get(0));
            if (++index % BATCH_SIZE != 0) continue;
            fullTextSession.flushToIndexes();
            fullTextSession.clear();
        }
        fullTextSession.flush();
        transaction.commit();
        fullTextSession.clear();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Book.class};
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        super.configure(cfg);
        cfg.put("hibernate.search.indexing_strategy", "manual");
    }

    private Blob getBlobData(String fileName, Session session) throws IOException {
        File file = new File(fileName);
        FileInputStream in = FileUtils.openInputStream((File)file);
        return session.getLobHelper().createBlob((InputStream)in, file.length());
    }

    static {
        try {
            File pdfFile = new File(TikaBridgeBlobSupportTest.class.getResource(TEST_DOCUMENT_PDF).toURI());
            PATH_TO_TEST_DOCUMENT_PDF = pdfFile.getAbsolutePath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unable to determine file path for test document");
        }
    }
}

