/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.polymorphism.uninitializedproxy;

import java.io.Serializable;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.embedded.polymorphism.uninitializedproxy.AbstractEntity;
import org.hibernate.search.test.embedded.polymorphism.uninitializedproxy.ConcreteEntity;
import org.hibernate.search.test.embedded.polymorphism.uninitializedproxy.LazyAbstractEntityReference;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1448")
public class SearchAfterUninitializedProxyEntityLoadingTest
extends SearchTestBase {
    private Integer entityId;
    private Integer entityReferenceId;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.populateDatabase();
    }

    @Test
    public void testSearchConcreteEntityWithoutPreLoadedProxy() {
        this.executeTest(ConcreteEntity.class, false);
    }

    @Test
    public void testSearchAbstractEntityWithoutPreLoadedProxy() {
        this.executeTest(AbstractEntity.class, false);
    }

    @Test
    public void testSearchConcreteEntityWithPreLoadedProxy() {
        this.executeTest(ConcreteEntity.class, true);
    }

    @Test
    public void testSearchAbstractEntityWithPreLoadedProxy() {
        this.executeTest(AbstractEntity.class, true);
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{AbstractEntity.class, ConcreteEntity.class, LazyAbstractEntityReference.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTest(Class<? extends AbstractEntity> clazz, boolean loadAbstractProxyBeforeSearch) {
        try (Session session = this.openSession();){
            if (loadAbstractProxyBeforeSearch) {
                LazyAbstractEntityReference reference = (LazyAbstractEntityReference)session.get(LazyAbstractEntityReference.class, (Serializable)this.entityReferenceId);
                Assert.assertTrue((reference != null && !Hibernate.isInitialized((Object)reference.getEntity()) ? 1 : 0) != 0);
            }
            Assert.assertEquals((long)1L, (long)SearchAfterUninitializedProxyEntityLoadingTest.doSearch(session, clazz, this.entityId).size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateDatabase() {
        try (Session session = this.openSession();){
            Transaction t = session.beginTransaction();
            ConcreteEntity entity = new ConcreteEntity();
            session.save((Object)entity);
            this.entityId = entity.getId();
            LazyAbstractEntityReference reference = new LazyAbstractEntityReference(entity);
            session.save((Object)reference);
            this.entityReferenceId = reference.getId();
            session.flush();
            t.commit();
        }
    }

    private static <T> List<T> doSearch(Session session, Class<T> clazz, Integer entityId) {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        FullTextQuery query = fullTextSession.createFullTextQuery((Query)new TermQuery(new Term("id", entityId.toString())), new Class[]{clazz});
        return query.list();
    }
}

