/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query;

import java.util.Iterator;
import java.util.List;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.FetchMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.hcore.util.impl.HibernateHelper;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.query.AlternateBook;
import org.hibernate.search.test.query.Author;
import org.hibernate.search.test.query.Book;
import org.hibernate.search.test.query.Clock;
import org.hibernate.search.test.query.Employee;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.stat.Statistics;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LuceneQueryTest
extends SearchTestBase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.indexTestData();
    }

    @Test
    public void testList() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "title", TestConstants.stopAnalyzer);
        Query query = parser.parse("summary:noword");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.size());
        query = parser.parse("summary:Festina Or brand:Seiko");
        hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"Query with explicit class filter", (long)2L, (long)result.size());
        query = parser.parse("summary:Festina Or brand:Seiko");
        hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Clock.class});
        result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"Query with one class filter", (long)1L, (long)result.size());
        query = parser.parse("summary:Festina Or brand:Seiko");
        hibQuery = fullTextSession.createFullTextQuery(query, new Class[0]);
        result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"Query with no class filter", (long)2L, (long)result.size());
        for (Object element : result) {
            Assert.assertTrue((boolean)HibernateHelper.isInitialized(element));
            fullTextSession.delete(element);
        }
        fullTextSession.flush();
        query = parser.parse("summary:Festina Or brand:Seiko");
        hibQuery = fullTextSession.createFullTextQuery(query, new Class[0]);
        result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"Query with delete objects", (long)0L, (long)result.size());
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testResultSize() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "title", TestConstants.stopAnalyzer);
        Query query = parser.parse("summary:Festina Or brand:Seiko");
        Statistics stats = fullTextSession.getSessionFactory().getStatistics();
        stats.clear();
        boolean enabled = stats.isStatisticsEnabled();
        if (!enabled) {
            stats.setStatisticsEnabled(true);
        }
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        Assert.assertEquals((String)"Exection of getResultSize without actual results", (long)2L, (long)hibQuery.getResultSize());
        Assert.assertEquals((String)"No entity should be loaded", (long)0L, (long)stats.getEntityLoadCount());
        query = parser.parse("summary:Festina Or brand:Seiko");
        hibQuery = fullTextSession.createFullTextQuery(query, new Class[0]);
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"2 entities should be loaded", (long)2L, (long)stats.getEntityLoadCount());
        if (!enabled) {
            stats.setStatisticsEnabled(false);
        }
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testResultSizeWithOffset() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "title", TestConstants.stopAnalyzer);
        Query query = parser.parse("summary:Festina Or brand:Seiko");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        hibQuery.setFirstResult(1);
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"first result no max result", (long)1L, (long)result.size());
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testMaxResultLessThanTotalNumberOfHits() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "title", TestConstants.stopAnalyzer);
        Query query = parser.parse("summary:Festina Or brand:Seiko");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        hibQuery.setFirstResult(0);
        hibQuery.setMaxResults(1);
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"max result set", (long)1L, (long)result.size());
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testMaxResultMoreThanTotalNumberOfHits() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "title", TestConstants.stopAnalyzer);
        Query query = parser.parse("summary:Festina Or brand:Seiko");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        hibQuery.setFirstResult(0);
        hibQuery.setMaxResults(3);
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"max result out of limit", (long)2L, (long)result.size());
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testMaxResultWithOffset() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "title", TestConstants.stopAnalyzer);
        Query query = parser.parse("summary:Festina Or brand:Seiko");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        hibQuery.setFirstResult(2);
        hibQuery.setMaxResults(3);
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"first result out of limit", (long)0L, (long)result.size());
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testIterator() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "title", TestConstants.stopAnalyzer);
        Query query = parser.parse("summary:noword");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        Iterator result = hibQuery.iterate();
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.hasNext());
        query = parser.parse("summary:Festina Or brand:Seiko");
        hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        result = hibQuery.iterate();
        Assert.assertNotNull((Object)result);
        int index = 0;
        while (result.hasNext()) {
            ++index;
            fullTextSession.delete(result.next());
        }
        Assert.assertEquals((long)2L, (long)index);
        fullTextSession.flush();
        query = parser.parse("summary:Festina Or brand:Seiko");
        hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        result = hibQuery.iterate();
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.hasNext());
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testScrollableResultSet() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "title", TestConstants.stopAnalyzer);
        Query query = parser.parse("summary:noword");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        ScrollableResults result = hibQuery.scroll();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)-1L, (long)result.getRowNumber());
        Assert.assertEquals((Object)false, (Object)result.next());
        result.close();
        query = parser.parse("summary:Festina Or brand:Seiko");
        hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        result = hibQuery.scroll();
        Assert.assertEquals((long)-1L, (long)result.getRowNumber());
        result.beforeFirst();
        Assert.assertEquals((Object)true, (Object)result.next());
        Assert.assertTrue((boolean)result.isFirst());
        Assert.assertTrue((boolean)result.scroll(1));
        Assert.assertTrue((boolean)result.isLast());
        Assert.assertFalse((boolean)result.scroll(1));
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testDefaultFetchSize() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "dept", TestConstants.standardAnalyzer);
        Query query = parser.parse("dept:ITech");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Employee.class});
        hibQuery.setProjection(new String[]{"id", "lastname", "dept"});
        ScrollableResults projections = hibQuery.scroll();
        projections.beforeFirst();
        Object[] projection = projections.get();
        Assert.assertNull((Object)projection);
        projections.next();
        Assert.assertTrue((boolean)projections.isFirst());
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testFetchSizeLargerThanHits() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "dept", TestConstants.standardAnalyzer);
        Query query = parser.parse("dept:ITech");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Employee.class});
        hibQuery.setProjection(new String[]{"id", "lastname", "dept"});
        hibQuery.setFetchSize(6);
        ScrollableResults results = hibQuery.scroll();
        results.beforeFirst();
        results.next();
        Object[] result = results.get();
        Assert.assertEquals((String)"incorrect entityInfo returned", (Object)1000, (Object)result[0]);
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testFetchSizeDefaultFirstAndMax() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "dept", TestConstants.standardAnalyzer);
        Query query = parser.parse("dept:ITech");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Employee.class});
        hibQuery.setSort(new Sort(new SortField("id", SortField.Type.STRING)));
        hibQuery.setProjection(new String[]{"id", "lastname", "dept"});
        hibQuery.setFetchSize(3);
        ScrollableResults results = hibQuery.scroll();
        results.beforeFirst();
        results.next();
        Object[] result = results.get();
        Assert.assertEquals((String)"incorrect entityInfo returned", (Object)1000, (Object)result[0]);
        results.scroll(2);
        result = results.get();
        Assert.assertEquals((String)"incorrect entityInfo returned", (Object)1003, (Object)result[0]);
        results.next();
        result = results.get();
        Assert.assertEquals((String)"incorrect entityInfo returned", (Object)1004, (Object)result[0]);
        results.scroll(-2);
        result = results.get();
        Assert.assertEquals((String)"incorrect entityInfo returned", (Object)1002, (Object)result[0]);
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testFetchSizeNonDefaultFirstAndMax() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "dept", TestConstants.standardAnalyzer);
        Query query = parser.parse("dept:ITech");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Employee.class});
        hibQuery.setProjection(new String[]{"id", "lastname", "dept"});
        hibQuery.setFetchSize(3);
        hibQuery.setFirstResult(1);
        hibQuery.setMaxResults(3);
        hibQuery.setSort(new Sort(new SortField("id", SortField.Type.STRING)));
        ScrollableResults results = hibQuery.scroll();
        results.beforeFirst();
        results.next();
        Object[] result = results.get();
        Assert.assertEquals((String)"incorrect entityInfo returned", (Object)1002, (Object)result[0]);
        results.scroll(2);
        result = results.get();
        Assert.assertEquals((String)"incorrect entityInfo returned", (Object)1004, (Object)result[0]);
        results.next();
        result = results.get();
        Assert.assertNull((Object)result);
        results.scroll(-8);
        result = results.get();
        Assert.assertNull((Object)result);
        results.scroll(10);
        result = results.get();
        Assert.assertNull((Object)result);
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testFetchSizeNonDefaultFirstAndMaxNoHits() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "dept", TestConstants.standardAnalyzer);
        Query query = parser.parse("dept:XXX");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Employee.class});
        hibQuery.setProjection(new String[]{"id", "lastname", "dept"});
        hibQuery.setFetchSize(3);
        hibQuery.setFirstResult(1);
        hibQuery.setMaxResults(3);
        ScrollableResults results = hibQuery.scroll();
        results.beforeFirst();
        Object[] result = results.get();
        Assert.assertNull((String)"non-null entity infos returned", (Object)result);
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testMaxResultZero() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "dept", TestConstants.standardAnalyzer);
        Query query = parser.parse("dept:foo");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Employee.class});
        hibQuery.setFirstResult(0);
        hibQuery.setMaxResults(0);
        List result = hibQuery.list();
        Assert.assertTrue((String)"We should get the empty result list", (boolean)result.isEmpty());
        hibQuery.setFirstResult(1);
        hibQuery.setMaxResults(0);
        result = hibQuery.list();
        Assert.assertTrue((String)"We should get the empty result list", (boolean)result.isEmpty());
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testCurrent() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "dept", TestConstants.standardAnalyzer);
        Query query = parser.parse("dept:ITech");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Employee.class});
        hibQuery.setProjection(new String[]{"id", "lastname", "dept"});
        ScrollableResults results = hibQuery.scroll();
        results.beforeFirst();
        results.next();
        Assert.assertTrue((String)"beforeFirst() pointer incorrect", (boolean)results.isFirst());
        results.afterLast();
        results.previous();
        Assert.assertTrue((String)"afterLast() pointer incorrect", (boolean)results.isLast());
        results.scroll(-8);
        results.next();
        Assert.assertTrue((String)"large negative scroll() pointer incorrect", (boolean)results.isFirst());
        results.scroll(10);
        results.previous();
        Assert.assertTrue((String)"large positive scroll() pointer incorrect", (boolean)results.isLast());
        hibQuery.setFirstResult(3);
        hibQuery.setMaxResults(1);
        results = hibQuery.scroll();
        results.first();
        Object[] result = results.get();
        Assert.assertEquals((Object)1004, (Object)result[0]);
        results.last();
        result = results.get();
        Assert.assertEquals((Object)1004, (Object)result[0]);
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testMultipleEntityPerIndex() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        AlternateBook alternateBook = new AlternateBook(1, "La chute de la petite reine a travers les yeux de Festina");
        fullTextSession.save((Object)alternateBook);
        tx.commit();
        fullTextSession.clear();
        tx = fullTextSession.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "title", TestConstants.stopAnalyzer);
        Query query = parser.parse("summary:Festina");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"Query with explicit class filter", (long)1L, (long)result.size());
        query = parser.parse("summary:Festina");
        hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        Iterator it = hibQuery.iterate();
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertNotNull(it.next());
        Assert.assertFalse((boolean)it.hasNext());
        query = parser.parse("summary:Festina");
        hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        ScrollableResults sr = hibQuery.scroll();
        Assert.assertTrue((boolean)sr.first());
        Assert.assertNotNull((Object)sr.get());
        Assert.assertFalse((boolean)sr.next());
        sr.close();
        query = parser.parse("summary:Festina OR brand:seiko");
        hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Clock.class, Book.class});
        hibQuery.setMaxResults(2);
        result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"Query with explicit class filter and limit", (long)2L, (long)result.size());
        query = parser.parse("summary:Festina");
        hibQuery = fullTextSession.createFullTextQuery(query, new Class[0]);
        result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"Query with no class filter", (long)2L, (long)result.size());
        for (Object element : result) {
            Assert.assertTrue((boolean)HibernateHelper.isInitialized(element));
        }
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testCriteria() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "title", TestConstants.stopAnalyzer);
        Query query = parser.parse("summary:Festina");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Book.class});
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"Query with no explicit criteria", (long)1L, (long)result.size());
        Book book = (Book)result.get(0);
        Assert.assertFalse((String)"Association should not be initialized", (boolean)HibernateHelper.isInitialized(book.getAuthors()));
        result = fullTextSession.createFullTextQuery(query, new Class[0]).setCriteriaQuery(fullTextSession.createCriteria(Book.class).setFetchMode("authors", FetchMode.JOIN)).list();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"Query with explicit criteria", (long)1L, (long)result.size());
        book = (Book)result.get(0);
        Assert.assertTrue((String)"Association should be initialized", (boolean)HibernateHelper.isInitialized(book.getAuthors()));
        Assert.assertEquals((long)1L, (long)book.getAuthors().size());
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testScrollEmptyHits() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "dept", TestConstants.standardAnalyzer);
        Query query = parser.parse("dept:XXX");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Employee.class});
        ScrollableResults projections = hibQuery.scroll();
        projections.beforeFirst();
        projections.next();
        Object[] projection = projections.get();
        Assert.assertNull((Object)projection);
        hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Employee.class}).setFirstResult(10).setMaxResults(20);
        projections = hibQuery.scroll();
        projections.beforeFirst();
        projections.next();
        projection = projections.get();
        Assert.assertNull((Object)projection);
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testListEmptyHits() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "dept", TestConstants.standardAnalyzer);
        Query query = parser.parse("dept:XXX");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Employee.class});
        List result = hibQuery.list();
        Assert.assertEquals((long)0L, (long)result.size());
        hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Employee.class}).setFirstResult(10).setMaxResults(20);
        result = hibQuery.list();
        Assert.assertEquals((long)0L, (long)result.size());
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testIterateEmptyHits() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "dept", TestConstants.standardAnalyzer);
        Query query = parser.parse("dept:XXX");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Employee.class});
        Iterator iter = hibQuery.iterate();
        Assert.assertFalse((boolean)iter.hasNext());
        hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Employee.class}).setFirstResult(10).setMaxResults(20);
        iter = hibQuery.iterate();
        Assert.assertFalse((boolean)iter.hasNext());
        tx.commit();
        fullTextSession.close();
    }

    private void indexTestData() {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        Clock clock = new Clock(1, "Seiko");
        fullTextSession.save((Object)clock);
        clock = new Clock(2, "Festina");
        fullTextSession.save((Object)clock);
        Book book = new Book(1, "La chute de la petite reine a travers les yeux de Festina", "La chute de la petite reine a travers les yeux de Festina, blahblah");
        fullTextSession.save((Object)book);
        Author emmanuel = new Author();
        emmanuel.setName("Emmanuel");
        fullTextSession.save((Object)emmanuel);
        book.getAuthors().add(emmanuel);
        book = new Book(2, "La gloire de mon p\u00e8re", "Les deboires de mon p\u00e8re en v\u00e9lo");
        fullTextSession.save((Object)book);
        fullTextSession.save((Object)new Employee(1000, "Griffin", "ITech"));
        fullTextSession.save((Object)new Employee(1001, "Jackson", "Accounting"));
        fullTextSession.save((Object)new Employee(1002, "Jimenez", "ITech"));
        fullTextSession.save((Object)new Employee(1003, "Stejskal", "ITech"));
        fullTextSession.save((Object)new Employee(1004, "Whetbrook", "ITech"));
        tx.commit();
        fullTextSession.close();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Book.class, AlternateBook.class, Clock.class, Author.class, Employee.class};
    }
}

