/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.facet;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Facet;
import org.hibernate.search.annotations.FacetEncodingType;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.builtin.IntegerBridge;

@Entity
@Indexed
public class Car {
    @Id
    @GeneratedValue
    private int id;
    @Field(analyze=Analyze.NO)
    @Facet
    private String color;
    @Field(analyze=Analyze.NO, store=Store.YES)
    @Facet
    private String make;
    @Field(analyze=Analyze.NO, bridge=@FieldBridge(impl=IntegerBridge.class))
    @Facet(encoding=FacetEncodingType.STRING)
    private int cubicCapacity;

    public Car() {
    }

    public Car(String make, String color, int cubicCapacity) {
        this.color = color;
        this.cubicCapacity = cubicCapacity;
        this.make = make;
    }

    public String getColor() {
        return this.color;
    }

    public int getCubicCapacity() {
        return this.cubicCapacity;
    }

    public int getId() {
        return this.id;
    }

    public String getMake() {
        return this.make;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Car");
        sb.append("{id=").append(this.id);
        sb.append(", color='").append(this.color).append('\'');
        sb.append(", make='").append(this.make).append('\'');
        sb.append(", cubicCapacity=").append(this.cubicCapacity);
        sb.append('}');
        return sb.toString();
    }
}

